/*******************************************************************************
 *	BConfig.h	Config File Access
 *			T.Barnaby,	BEAM Ltd,	2009-01-28
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BConfig_H
#define	BConfig_H

#include <BDict.h>
#include <BFile.h>
#include <BMutex.h>

/// This class implements the configuration file access
class BConfig : public BDictString {
public:
	BError		open(BString fileName, BString mode = "r");
	void		close();
	BError		read();
	BError		write();
	
	BString		findValue(BString name);
	BString		fileName();

private:
	BMutex		olock;
	BString		ofileName;
	BFile		ofile;
};
#endif
