/*******************************************************************************
 *	BAtomicCount.h		BAtomicCount Atomic Counter
 *			T.Barnaby,	BEAM Ltd,	2008-06-17
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BAtomicCount_H
#define BAtomicCount_H	1

#if TARGET_vdc
/// BAtomicCount class
class BAtomicCount {
public:
			BAtomicCount(long value = 0) : ovalue(value){}

	long		getValue() const {
				return __sync_fetch_and_add(&ovalue, 0);
			}
	long		add(long value){
				return __sync_fetch_and_add(&ovalue, value) + value;
			}
	long		operator++(int){
				return __sync_fetch_and_add(&ovalue, 1);
			}	
	long		operator++(){
				return __sync_fetch_and_add(&ovalue, 1) + 1;
			}	
	long		operator--(int){
				return __sync_fetch_and_add(&ovalue, -1);
			}
	long		operator--(){
				return __sync_fetch_and_add(&ovalue, -1) - 1;
			}
			operator long() const {
				return getValue();
			}
private:
	mutable long	ovalue;
};
#else
#if __GNUC__ >= 5 || __GNUC_MINOR__ >= 4
#include <ext/atomicity.h>
#else
#include <bits/atomicity.h>
#endif

/// BAtomicCount class
class BAtomicCount {
public:
			BAtomicCount(long value = 0) : ovalue(value){}

	long		getValue() const {
				return __gnu_cxx::__exchange_and_add(&ovalue, 0);
			}
	long		add(long value){
				return __gnu_cxx::__exchange_and_add(&ovalue, value) + value;
			}
	long		operator++(int){
				return __gnu_cxx::__exchange_and_add(&ovalue, 1);
			}	
	long		operator++(){
				return __gnu_cxx::__exchange_and_add(&ovalue, 1) + 1;
			}	
	long		operator--(int){
				return __gnu_cxx::__exchange_and_add(&ovalue, -1);
			}
	long		operator--(){
				return __gnu_cxx::__exchange_and_add(&ovalue, -1) - 1;
			}
			operator long() const {
				return getValue();
			}
private:
	mutable _Atomic_word	ovalue;
};
#endif

#endif
