/*******************************************************************************
 *	GenBoapSwigPython.cc	Boap output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#define	DEBUG	1

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <GenBoapSwigPython.h>
#include <bidl.h>

BError GenBoapSwigPython::produceImp(Node* n){
	BError		err;
	BIter		i;
	BString		s;
	BString		c;
	BList<Node*>*	nl;

	switch(n->nodeType()){
	case Node::TMODULE:
		omodule = n->name();
		ofunctions.writeLine(BString("namespace ") + omodule + " {\n");
		ofunctions.indentMore();

		ofunctions.writeLine(BString("const BUInt32 apiVersion = ") + oapiVersion + ";\n\n");
		
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			err = produceImp(n->nodes()[i]);
		}
		ofunctions.indentLess();
		ofunctions.writeLine("}\n");
		break;
	case Node::TINTERFACE:
		ointerface = n->name();
		// Client
		ofunctions.writeLine(BString("class ") + ointerface + " : public BoapClientObject {\n");
		ofunctions.writeLine("public:\n");
		ofunctions.indentMore();
		ofunctions.writeLine(BString("\t") + ointerface + "(BString name = \"\");\n");
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			err = produceImp(n->nodes()[i]);
		}
		ofunctions.indentLess();
		ofunctions.writeLine("private:\n");
		ofunctions.writeLine("};\n");
		break;
	case Node::TLIST:
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			err = produceImp(n->nodes()[i]);
		}
		break;

	case Node::TSTRUCT:
		{
		BString	fullName = omodule + "::" + n->name();

		s.printf("%%typemap(in, numinputs=0) %s& OUTPUT (%s temp){\n", fullName.retStr(), fullName.retStr());
		otypes.writeLine(s);
		otypes.writeLine("\t$1 = &temp;\n");
		otypes.writeLine("}\n");
		
		s.printf("%%typemap(argout) %s& {\n", fullName.retStr());
		otypes.writeLine(s);
		s.printf("\t%s*\ttemp = new %s();\n", fullName.retStr(), fullName.retStr());
		otypes.writeLine(s);
		s.printf("\t*temp = *$1;\n", fullName.retStr(), fullName.retStr());
		otypes.writeLine(s);
		s.printf("\t$result = SWIG_Python_AppendOutput($result, SWIG_NewPointerObj(SWIG_as_voidptr(temp), SWIGTYPE_p_%s__%s, SWIG_POINTER_OWN));\n", omodule.retStr(), n->name().retStr());
		otypes.writeLine(s);
		otypes.writeLine("}\n");
		
		// List outputs
		s.printf("%%typemap(in, numinputs=0) BList<%s>& OUTPUT (){\n", fullName.retStr(), fullName.retStr());
		otypes.writeLine(s);
		otypes.writeLine(s.printf("\t$1 = new BList<%s>;\n", fullName.retStr()));
		otypes.writeLine("}\n");
		
		s.printf("%%typemap(argout) BList<%s>& {\n", fullName.retStr());
		otypes.writeLine(s);
		s.printf("\t$result = SWIG_Python_AppendOutput($result, SWIG_NewPointerObj(SWIG_as_voidptr($1), SWIGTYPE_p_BListT_%s__%s_t, SWIG_POINTER_OWN));\n", omodule.retStr(), n->name().retStr());
		otypes.writeLine(s);
		otypes.writeLine("}\n");
		
		otypes.writeLine("\n");
		}
		break;

	case Node::TFUNC:
		s = s + getTypeName(n->node(0)) + " ";
		s = s + n->name() + "(";
		nl = &n->node(1)->nodes();
		for(nl->start(i); !nl->isEnd(i); nl->next(i)){
			if(i != nl->begin())
				s = s + ", ";
			if(nl->get(i)->node(0)->name() == "in"){
				s = s + getTypeName(nl->get(i)->node(1)) + " ";
				s = s + nl->get(i)->node(2)->name();
			}
			else if(nl->get(i)->node(0)->name() == "inref"){
				s = s + "const " + getTypeName(nl->get(i)->node(1)) + "& INPUT";
			}
			else if(nl->get(i)->node(0)->name() == "out"){
				s = s + getTypeName(nl->get(i)->node(1)) + "& OUTPUT";
			}
			else if(nl->get(i)->node(0)->name() == "inout"){
				s = s + getTypeName(nl->get(i)->node(1)) + "& INOUT";
			}
			else {
				s = s + getTypeName(nl->get(i)->node(1)) + "& ";
				s = s + nl->get(i)->node(2)->name();
			}
		}
		s = s + ");";
		if(n->node(2) && n->node(2)->nodeType() == Node::TCOMMENT)
			s = s + "\t//" + n->node(2)->name();
		ofunctions.writeLine(s + "\n");
		break;
	case Node::TCOMMENT:
		s = BString("//") + n->name() + "\n";
//		ofunctions.writeLine(s);
		break;
	case Node::TAPIVERSION:
		oapiVersion = n->name().retInt();
		break;
	default:
		break;
	}
	return err;
}

BError GenBoapSwigPython::produceHeader(){
	BError	err;
	BString	fileName = ofileName + ".i";

	ofile.printf("/*******************************************************************************\n");
	ofile.printf(" *\t%s\tProduced by Bidl\n", fileName.retStr());
	ofile.printf(" *******************************************************************************\n");
	ofile.printf(" */\n");
	ofile.printf("\n");
	ofile.printf("\n");
	return err;
}

BError GenBoapSwigPython::produceTrailer(){
	BError	err;
	
	ofile.printf("\n");
	return err;
}

BString GenBoapSwigPython::getTypeSwapList(Node* n){
	BString	typeName;
	Type*	t;
	BIter	i;
	BString	typeList;

	typeName = n->name();
//	printf("isRawType: %d %s\n", n->nodeType(), typeName.retStr());

	if(n->nodeType() == Node::TTYPEARRAY){
		return "";
	}
	else if(n->nodeType() == Node::TTYPEDICT){
		return "";
	}
	else if(n->nodeType() == Node::TTYPE){
		if(typeName == "Int8")		return "1";
		else if(typeName == "UInt8")	return "1";
		else if(typeName == "Int16")	return "2";
		else if(typeName == "UInt16")	return "2";
		else if(typeName == "Int32")	return "4";
		else if(typeName == "UInt32")	return "4";
		else if(typeName == "Bool")	return "4";
		else if(typeName == "String")	return "";
		else if(typeName == "Error")	return "";
		else if(typeName == "Date")	return "";
		else if(typeName == "DateTime")	return "";
		else if(typeName == "Id")	return "";
		else if(typeName == "ObjData")	return "";
		else if(typeName == "TimeStamp")	return "";
		else if(typeName == "Complex")	return "";
		else {
			if(t = gtypelist.search(typeName)){
				if(t->node()){
					return  getTypeSwapList(t->node());
				}
			}
			else
				return "";
		}
	}
	else if(n->nodes().number()){
		for(n->nodes().start(i); !n->nodes().isEnd(i); n->nodes().next(i)){
			typeList += getTypeSwapList(n->nodes()[i]);
		}

		return typeList;
	}
	return "";
}

GenBoapSwigPython::GenBoapSwigPython(){
	ofuncNum = 0;
	opushPopDepth = 0;
	oapiVersion = 0;
	
	setUseBObjects(0);
}

GenBoapSwigPython::~GenBoapSwigPython(){
}

BError GenBoapSwigPython::produce(Node* n, BString fileName){
	BError	err;
	
//	dprintf("GenBoapSwigPython::produce: %x\n", n);
	ofileName = fileName;
	ofile.open(fileName + ".i", "w");
	
	// File Header
	produceHeader();
	
	// Generate code
	produceImp(n);
	ofile.writeString(otypes);
	ofile.writeString(ofunctions);
	
	// Generate trailers
	produceTrailer();
	ofile.close();
	return err;
}

