/*******************************************************************************
 *	GenBoapPython.h	Generate output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#ifndef GenBoapPython_h
#define GenBoapPython_h

#include <Gen.h>

class GenBoapPython : public Gen {
public:
			GenBoapPython();
			~GenBoapPython();

	BError		produce(Node* n, BString fileName);
	BString		getTypeName(Node* n, int data = 0);

private:
	BError		produceHeaderPython();
	void		produceImpPython(Node* n);
	BError		produceTrailerPython();

	BError		produceHeaderWrap();
	void		produceImpWrap(Node* n);
	BError		produceTrailerWrap();

	void		pushPopVar(FileIndent& file, int push, BString func, Node* type, BString name);
	void		produceFunc(Node* n);
	void		produceFuncAdd(Node* n);
	
	BString		getTypeSwapList(Node* n);
	BString		getTypeInitialiser(BString typeName);

	BString		ofileName;
	BStringList	oclassFunctions;
	
	BStringList	oclasses;
	BStringList	ofunctions;

	FileIndent	ofilePython;
	FileIndent	ofileWrap;
	StringIndent	oconvertors;
	BString		omodule;
	BString		ointerface;
	int		ofuncNum;
	int		opushPopDepth;
	int		oapiVersion;
};

#endif
