/*******************************************************************************
 *	GenBoapPhp.h	Generate Data output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#ifndef GenBoapPhp_h
#define GenBoapPhp_h

#include <Gen.h>

class GenBoapPhp : public Gen {
public:
			GenBoapPhp();
			~GenBoapPhp();
	BError		produce(Node* n, BString fileName);
	BString		getTypeNamePhp(Node* n, int data = 0);
	BString		getTypeSwapList(Node* n);

private:
	BError		produceHeaderImp();
	BError		produceTrailerImp();
	void		produceImp(Node* n);
	void		produceFunc(Node* n);

	BString		ofileName;
	FileIndent	ofileImp;
	BString		omodule;
	BString		ointerface;
	BString		ointerfacePhp;
	int		ofuncNum;
	int		opushPopDepth;
	StringIndent	oconvertors;
	BStringList	oclasses;
	BStringList	oclassFunctions;
	BStringList	ointerfaces;
};

#endif
