/*
* Title:	tmsControlMainGui.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Primary interface for Cern TMS system test/debug Gui
*
* Mod Rec:
*
*/

#include <qmenubar.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qinputdialog.h>
#include <qimage.h>

#include <tmsDataMainWin.h>
#include <Globals.h>
#include <unistd.h>
#include <BGraph.h>
#include <math.h>

TmsDataMainWin::TmsDataMainWin(){
}

TmsDataMainWin::~TmsDataMainWin(){
}

void TmsDataMainWin::initMenubar(){
	QPopupMenu*	m;
	QAction*	a;
	
	m = new QPopupMenu();
	a = addAction(m, tr("New Connection"), tr("&New Connection"), tr("Ctrl+N"), SLOT(slotNewConnection()), tr("Starts a new job"));
	a = addAction(m, tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application"));
	menuBar()->insertItem(tr("&File"), m);

	m = new QPopupMenu();
	a = addAction(m, tr("Prefferences"), tr("&Prefferences"), tr("Ctrl+P"), SLOT(slotPrefferences()), tr("Setup prefferences"));
	menuBar()->insertItem(tr("&Options"), m);

        menuBar( )->insertSeparator(-1);
	m = new QPopupMenu();
//	a = addAction(m, tr("Whats This"), tr("&Whats This"), tr("Ctrl+W"), SLOT(slotEnterWhatsThis()), tr("Enter Whats This mode"));
	a = addAction(m, tr("Manual"), tr("&Manual"), tr("Ctrl+M"), SLOT(slotManual()), tr("Online Manual"));
	a = addAction(m, tr("TMS Manual"), tr("&TMS Manual"), tr("Ctrl+T"), SLOT(slotTmsManual()), tr("TMS System Manual"));
	a = addAction(m, tr("About"), tr("&About"), tr("Ctrl+A"), SLOT(slotAbout()), tr("About the program"));
	menuBar()->insertItem(tr("&Help"), m);
//	setMinimumSize(QSize(1024,850));
}

void TmsDataMainWin::initMain(){
	BError		err;
	QFont		f;
	QStatusBar*	wstatusBar;
	BString 	host;
	BGraph*		graph;
	
	if (ghostName.len() > 0) {
		host = ghostName;
	}
	else {
		host = gconfig.findValue("DefaultServer:");
	}
#ifdef ZAP
	if (host.len() > 0) 
		ocontrol.setHost(host);
#endif

	otabd     	= new QTabWidget(this);
	setCentralWidget(otabd);
	otabd->setName("Tab Widget");
	otabd->setMinimumSize(1000,860);
	otabd->setTabPosition(QTabWidget::Bottom);
	
	graph = new BGraph(this);
	
	BArray<float>	data(100);
	int		n;
	
	for(n = 0; n < 100; n++){
		data[n] = sin(2.0 * 3.14159 * 5 * n / 100);
	}
	graph->setPlotType(BGraph::POINTS);
	graph->setGrid(16,16);
	graph->setData(data);
	
	otabd->addTab(graph, "Data View");
	otabd->show();

	f = qApp->font();
	f.setPointSize(10);
	qApp->setFont(f,true);
	
	wstatusBar = statusBar();
}

void	TmsDataMainWin::slotQuit() {
	exit(0);
}

void	TmsDataMainWin::initToolbar() {
}


void	TmsDataMainWin::slotPrefferences() {
	ooptionsWin->show();
}

void	TmsDataMainWin::slotEnterWhatsThis() {
	whatsThis();
}

void	TmsDataMainWin::warningDialog(BString title,BError err,BString msg){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + msg + "<br>" + err.getString() + "</p>";
	QMessageBox::warning(this, "tmsControlGui - Warning", m.retStr());
}

void	TmsDataMainWin::slotNewConnection() {
	BError	err;
	bool	ok;
	BString	host = ghostName;
	QString	s = host.retStr();
	
//	host = QInputDialog::getText("tsmControlGui", "Enter Host Name:",QLineEdit::Normal,QString::null, &ok, this );
	host = QInputDialog::getText("tsmControlGui", "Enter Host Name:",QLineEdit::Normal, s, &ok, this );
    	if (ok && (host.len() > 0)) {
		ghostName = host;
	}	
#ifdef ZAP
	if (err = ocontrol.init()) {
		BString msg = BString("Attempting to conect to (") + host + ")";
		warningDialog("Connecting to Remote",err,msg);
	}
#endif
}

void TmsDataMainWin::slotAbout() {
	BString		msg;
	QImage		logo("alphadata_beam_logo.png");
	QMessageBox	mbox(this);
	
	
	msg = "<p><b>tmsControlGui</b> - Trajectory Measurement System Test Interface</p>";
	msg += BString("<p>&copy; BEAM Ltd 2007</p><p>Version: ") + VERSION + "</p>";

	mbox.setIconPixmap(logo);
	mbox.setCaption("About");
	mbox.setText(msg.retStr());
	mbox.exec();
}

void TmsDataMainWin::slotManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/TmsControlGui.pdf");
	fnames.append("./TmsControlGui.pdf");
	fnames.append("../doc/TmsControlGui.pdf");
	fnames.append("../../doc/TmsControlGui.pdf");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}




void TmsDataMainWin::slotTmsManual() {
	BIter		i;
	BList<BString>	fnames;
	BString		fname;
	BString		cmd;
	
	fnames.append("/usr/tms/doc/index.html");
	fnames.append("./index.html");
	fnames.append("../doc/index.html");
	fnames.append("../../doc/index.html");

	for (fnames.start(i);! fnames.isEnd(i); fnames.next(i)) {
		if (access(fnames[i].retStr(),R_OK) == 0) {
			fname = fnames[i];
			break;
		}	
	}
	if (! fnames.isEnd(i)) {
		cmd =BString("firefox ") + fname + "&";
		system(cmd.retStr());
	}
	else {
		QMessageBox::warning(this, "Warning", "Unable to locate the help files");
	}
}





