/*
** sensort.h - scalar types used in ADMXRC2 API Sensor extension
**
** (C) Copyright 2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_SENSORT_H
#define _ADATA_ADMXRC2_SENSORT_H

/* Datatype for representing the datatype of sensor readings */
typedef enum _ADMXRC2_DATA_TYPE {
  ADMXRC2_DATA_BOOL      = 0, /* BOOL (Windows) or int (Linux / VxWorks) */
  ADMXRC2_DATA_DOUBLE    = 1, /* double */
  ADMXRC2_DATA_INT32     = 2, /* INT32 (Windows) or int32_t (Linux / VxWorks) */
  ADMXRC2_DATA_UINT32    = 3, /* UINT32 (Windows) or uint32_t (Linux / VxWorks) */
  ADMXRC2_DATA_LASTVALUE = 4, /* Reserved for adding new data types */
  ADMXRC2_DATA_FORCE32BITS = 0x7FFFFFFF
} ADMXRC2_DATA_TYPE;

/* Datatype for representing the unit of a sensor */
typedef enum _ADMXRC2_UNIT_TYPE {
  ADMXRC2_UNIT_NONE      = 0, /* For unitless quantities */
  ADMXRC2_UNIT_A         = 1, /* Amperes */
  ADMXRC2_UNIT_V         = 2, /* Volts */
  ADMXRC2_UNIT_C         = 3, /* Degrees Celsius */
  ADMXRC2_UNIT_HZ        = 4, /* Hz */
  ADMXRC2_UNIT_RPM       = 5, /* Revolutions per minute */
  ADMXRC2_UNIT_S         = 6, /* Seconds */
  ADMXRC2_UNIT_LASTVALUE = 7, /* Reserved for adding new units */
  ADMXRC2_UNIT_FORCE32BITS = 0x7FFFFFFF
} ADMXRC2_UNIT_TYPE;

#endif
