/*
** <admxrc2/physdmas.h> - Structures supporting ADMXRC2 API Physical DMA
**                        extension.
**
** (C) Copyright 2006, 2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_PHYSDMAS_H
#define _ADATA_ADMXRC2_PHYSDMAS_H

typedef struct _ADMXRC2_PHYSDMA_DESC {
  _ADMXRC2_UINT32 PciLow;  /* PCI address of buffer */
  _ADMXRC2_UINT32 PciHigh; /* Must be zero */
  _ADMXRC2_UINT32 Local;   /* Local bus address of destination or source buffer */
  _ADMXRC2_UINT32 Length;  /* Number of bytes to transfer in this block */
} ADMXRC2_PHYSDMA_DESC;

/*
** ADMXRC2_DoDMAPhysical() flags
*/
#define ADMXRC2_DMAFLAG_CIRCULAR (0x1 << 0)

#endif
