/*
** flashinf.h - Structures and types used in ADMXRC2 API calls relating to
**              Flash memory access.
**
** (C) Copyright 2003-2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_FLASHINF_H
#define _ADATA_ADMXRC2_FLASHINF_H

/*
** Flash information structure
*/
typedef struct _ADMXRC2_FLASH_INFO {
  char            DeviceName[32];  /* Freeform string of device name                                       */
  _ADMXRC2_UINT32 DeviceSize;      /* Size of device                                                       */
  _ADMXRC2_UINT32 DeviceBlockSize; /* Device normal block size                                             */
  _ADMXRC2_UINT32 UseableStart;    /* Starting address of region in device for target FPGA bitstreams etc. */
  _ADMXRC2_UINT32 UseableLength;   /* Length of region in device for target FPGA bitstreams etc.           */
} ADMXRC2_FLASH_INFO;

/*
** Flash block information structure
*/
typedef struct _ADMXRC2_FLASHBLOCK_INFO {
  _ADMXRC2_UINT32 Flags;  /* See flags definitions above */
  _ADMXRC2_UINT32 Start;  /* Size of block               */
  _ADMXRC2_UINT32 Length; /* Length of block             */
} ADMXRC2_FLASHBLOCK_INFO;

#endif
