/*
** flash.h - Defines ADMXRC2 API calls relating to Flash memory access.
**
** (C) Copyright 2003-2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_FLASH_H
#define _ADATA_ADMXRC2_FLASH_H

#include <admxrc2.h>
#include <admxrc2/flashinf.h>

#ifdef __cplusplus
extern "C" {
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_EraseFlash(
  ADMXRC2_HANDLE             hCard,
  unsigned long              start,
  unsigned long              length);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetFlashInfo(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_FLASH_INFO*        pFlashInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetFlashBlockInfo(
  ADMXRC2_HANDLE             hCard,
  unsigned long              location,
  ADMXRC2_FLASHBLOCK_INFO*   pFlashBlockInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ReadFlash(
  ADMXRC2_HANDLE             hCard,
  unsigned long              start,
  unsigned long              length,
  void*                      pBuffer);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_WriteFlash(
  ADMXRC2_HANDLE             hCard,
  unsigned long              start,
  unsigned long              length,
  const void*                pData);

#ifdef __cplusplus
} 
#endif

#endif
