/*
** <admxrc2/combuffs.h> - Structures supporting ADMXRC2 API Direct Master common buffer
**                        extension.
**
** (C) Copyright 2003-2014 Alpha Data
*/

#ifndef _ADATA_ADMXRC2_COMBUFFS_H
#define _ADATA_ADMXRC2_COMBUFFS_H

/*
** Information about Direct Master common buffer.
*/
typedef struct _ADMXRC2_COMMONBUFFER_INFO {
  void*           VirtualBase;  /* Application space virtual base address of buffer */
#if defined(_WIN32)
  /* This is LARGE_INTEGER (as opposed to a 64-bit scalar type) for historical compatibility reasons */
  LARGE_INTEGER   PhysicalBase; /* Bus-relative base address of buffer */
#else            
  _ADMXRC2_UINT64 PhysicalBase; /* Bus-relative base address of buffer */
#endif
  unsigned long   Size;         /* Size of buffer, in bytes                         */
} ADMXRC2_COMMONBUFFER_INFO;

#endif
