#ifndef _ADATA_ADMXRC2_H
#define _ADATA_ADMXRC2_H

/*
** <admxrc2.h> - ADMXRC2 API header file (ADMXRC2 interface)
**
** (C) Copyright 2001-2014 Alpha Data
**
** The integer datatypes used below that are prefixed by "_ADMXRC2_", such
** as "_ADMXRC2_UINT64" are defined in order to increase the portability of
** this header file but should NOT be used by application code that makes
** use of the ADMXRC2 API.
**
** Applications should use OS-specific types such as UINT32 (Windows) or
** uint32_t (Linux C99).
*/

#if defined(_WIN32) || defined(_MSC_VER)

/* Windows */

# include <windows.h>
# include <tchar.h>

# if defined(ADMXRC2_DLL)
    /* Compiling API library into a DLL */
#   define ADMXRC2_EXPORT __declspec(dllexport)
# else
    /* Importing API library from DLL */
#   define ADMXRC2_EXPORT __declspec(dllimport)
# endif
# define ADMXRC2_CALLING_CONVENTION __cdecl

#elif defined(__linux)

/* Linux */

# include <stdint.h>
# include <wchar.h>

# define ADMXRC2_EXPORT
# define ADMXRC2_CALLING_CONVENTION

#elif defined(__VXWORKS__) || defined(__vxworks)

# include <vxWorks.h>
# include <semLib.h>

# define ADMXRC2_EXPORT
# define ADMXRC2_CALLING_CONVENTION

#else

# error Cannot detect target operating system.

#endif

#include <admxrc2/platform.h>
#include <admxrc2/status.h>
#include <admxrc2/types.h>
#include <admxrc2/struct.h>

/* Revision of the ADMXRC2 API to which these header files apply */
#define ADMXRC2_H_MAKE_VERSION(super, major, minor) ((super) * 65536 + (major) * 256 + (minor))
#define ADMXRC2_H_VERSION_SUPER (1)
#define ADMXRC2_H_VERSION_MAJOR (0)
#define ADMXRC2_H_VERSION_MINOR (0)
#define ADMXRC2_H_VERSION ADMXRC2_H_MAKE_VERSION(ADMXRC2_H_VERSION_SUPER, ADMXRC2_H_VERSION_MAJOR, ADMXRC2_H_VERSION_MINOR)

#ifdef __cplusplus
extern "C" {
#endif

ADMXRC2_EXPORT _ADMXRC2_DWORD
ADMXRC2_CALLING_CONVENTION
ADMXRC2_BuildDMAModeWord(
  ADMXRC2_BOARD_TYPE         boardType,
  ADMXRC2_IOWIDTH            busWidth,
  unsigned int               waitStates,
  _ADMXRC2_DWORD             miscFlags);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_CancelWaitForInterrupt(
  ADMXRC2_HANDLE             hCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_CloseCard(
  ADMXRC2_HANDLE             hCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromBuffer(
  ADMXRC2_HANDLE             hCard,
  const void*                pBuffer,
  unsigned long              length);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromBufferDMA(
  ADMXRC2_HANDLE             hCard,
  const void*                pBuffer,
  unsigned long              length,
  unsigned int               dmaChannel,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromBufferDMAEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC2_DWORD             flags,
  const void*                pBuffer,
  unsigned long              length,
  unsigned int               dmaChannel,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromBufferEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC2_DWORD             flags,
  const void*                pBuffer,
  size_t                     length);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromFile(
  ADMXRC2_HANDLE             hCard,
  const char*                pBitFilename);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromFileDMA(
  ADMXRC2_HANDLE             hCard,
  const char*                pBitFilename,
  unsigned int               dmaChannel,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromFileDMAEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC2_UINT32            flags,
  const char*                pFilename,
  unsigned int               dmaChannel,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ConfigureFromFileEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC2_UINT32            flags,
  const char*                pFilename);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_DoDMA(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_DMADESC            hDmaDescriptor,
  unsigned long              offset,
  unsigned long              length,
  _ADMXRC2_DWORD             local,
  ADMXRC2_DMADIR             direction,
  unsigned int               dmaChannel,
  _ADMXRC2_DWORD             dmaMode,
  _ADMXRC2_DWORD             flags,
  unsigned long*             pTimeoutUs,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_DoDMAImmediate(
  ADMXRC2_HANDLE             hCard,
  void*                      pBuffer,
  unsigned long              length,
  _ADMXRC2_DWORD             local,
  ADMXRC2_DMADIR             direction,
  unsigned int               dmaChannel,
  _ADMXRC2_DWORD             dmaMode,
  _ADMXRC2_DWORD             flags,
  unsigned long*             pTimeoutUs,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

typedef void (*ADMXRC2_ENUM_FUNCTION)(unsigned int index, ADMXRC2_HANDLE card);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_EnumerateCards(
  ADMXRC2_ENUM_FUNCTION      enumerationFunction);

ADMXRC2_EXPORT void
ADMXRC2_CALLING_CONVENTION
ADMXRC2_Free(
  void*                      pObject);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetBankInfo(
  ADMXRC2_HANDLE             hCard,
  unsigned int               bankIndex,
  ADMXRC2_BANK_INFO*         pBankInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetCardInfo(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_CARD_INFO*         pCardInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetCardInfoEx(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_CARD_INFOEX*       pCardInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetFPGAInfo(
  ADMXRC2_HANDLE             hCard,
  unsigned int               fpgaIndex,
  ADMXRC2_FPGA_INFO*         pFpgaInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetSpaceInfo(
  ADMXRC2_HANDLE             hCard,
  unsigned int               spaceIndex,
  ADMXRC2_SPACE_INFO*        pSpaceInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetSpaceInfoEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               spaceIndex,
  ADMXRC2_SPACE_INFOEX*      pSpaceInfoEx);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetSpaceConfig(
  ADMXRC2_HANDLE             hCard,
  unsigned int               spaceIndex,
  _ADMXRC2_DWORD*            pSpaceFlags);

ADMXRC2_EXPORT const char*
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetStatusString(
  ADMXRC2_STATUS             status);

ADMXRC2_EXPORT const char*
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetStatusStringEx(
  ADMXRC2_STATUS             status,
  _ADMXRC2_BOOL              bShort);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetVersionInfo(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_VERSION_INFO*      pVersionInfo);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_GetVersionInfoEx(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_VERSION_INFOEX*    pVersionInfo);

typedef void (*ADMXRC2_ERROR_HANDLER)(const char* FnName, ADMXRC2_STATUS Status);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_InstallErrorHandler(
  ADMXRC2_ERROR_HANDLER      handler);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_LoadBitstream(
  ADMXRC2_HANDLE             hCard,
  const char*                pBitFilename,
  ADMXRC2_IMAGE*             pImage,
  unsigned long*             pNumBytesRead);

ADMXRC2_EXPORT void*
ADMXRC2_CALLING_CONVENTION
ADMXRC2_Malloc(
  unsigned long              sizeInBytes);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_MapDirectMaster(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_DMADESC            hDmaDescriptor,
  unsigned long              offset,
  unsigned long              length,
  ADMXRC2_BUFFERMAP*         pBufferMap);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_OpenCard(
  ADMXRC2_CARDID             cardId,
  ADMXRC2_HANDLE*            phCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_OpenCardEx(
  ADMXRC2_CARDID             cardId,
  _ADMXRC2_UINT32            flags,
  _ADMXRC2_BOOL              bPassive,
  _ADMXRC2_UINT32            cooperativeLevel,
  ADMXRC2_HANDLE*            phCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_OpenCardByIndex(
  unsigned int               cardIndex,
  ADMXRC2_HANDLE*            phCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_OpenCardByIndexEx(
  unsigned int               cardIndex,
  _ADMXRC2_UINT32            flags,
  _ADMXRC2_BOOL              bPassive,
  _ADMXRC2_UINT32            cooperativeLevel,
  ADMXRC2_HANDLE*            phCard);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ProgramBytes(
  ADMXRC2_HANDLE             hCard,
  const _ADMXRC2_DWORD*      pProgram,
  unsigned long              programLength);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_Read(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_IOWIDTH            width,
  _ADMXRC2_DWORD             flags,
  _ADMXRC2_DWORD             localAddress,
  void*                      pBuffer,
  unsigned long              length);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_ReadConfig(
  ADMXRC2_HANDLE             hCard,
  unsigned long              locationIndex,
  _ADMXRC2_DWORD*            pValue);

#if defined(_WIN32) || defined(_MSC_VER)
ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_RegisterInterruptEvent(
  ADMXRC2_HANDLE             hCard,
  HANDLE                     hEvent);
#endif

#if defined(__VXWORKS__) || defined(__vxworks)
ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_RegisterInterruptEvent(
  ADMXRC2_HANDLE             hCard,
  SEM_ID                     hVxWorksSem);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SetClockRate(
  ADMXRC2_HANDLE             hCard,
  unsigned int               clockIndex,
  double                     requestedFrequency,
  double*                    pActualFrequency);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SetClockRateEx(
  ADMXRC2_HANDLE             hCard,
  unsigned int               clockIndex,
  _ADMXRC2_UINT32            flags,
  double                     requestedFrequency,
  double*                    pActualFrequency);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SetCoopLevel(
  ADMXRC2_HANDLE             hCard,
  _ADMXRC2_UINT32            newLevel);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SetSpaceConfig(
  ADMXRC2_HANDLE             hCard,
  unsigned int               spaceIndex,
  _ADMXRC2_DWORD             spaceFlags);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SetupDMA(
  ADMXRC2_HANDLE             hCard,
  const void*                pBuffer,
  unsigned long              size,
  _ADMXRC2_DWORD             flags,
  ADMXRC2_DMADESC*           phDmaDescriptor);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_StatusToString(
  ADMXRC2_STATUS             statusCode,
  char*                      pStringBuffer,
  unsigned long              bufferLength);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_SyncDirectMaster(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_DMADESC            hDmaDescriptor,
  unsigned long              offset,
  unsigned long              length,
  ADMXRC2_SYNCMODE           syncMode);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_Unconfigure(
  ADMXRC2_HANDLE             hCard,
  unsigned int               targetIndex,
  _ADMXRC2_UINT32            flags);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_UnloadBitstream(
  ADMXRC2_IMAGE              image);

#if defined(_WIN32) || defined(_MSC_VER)
ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_UnregisterInterruptEvent(
  ADMXRC2_HANDLE             hCard,
  HANDLE                     hWin32Event);
#endif

#if defined(__VXWORKS__) || defined(__vxworks)
ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_UnregisterInterruptEvent(
  ADMXRC2_HANDLE             hCard,
  SEM_ID                     hVxWorksSem);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_UnsetupDMA(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_DMADESC            hDmaDescriptor);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_WaitForInterrupt(
  ADMXRC2_HANDLE             hCard,
  unsigned long*             pTimeoutUs,
  unsigned long              flags,
#if defined(_WIN32) || defined(_MSC_VER)
  HANDLE                     hEvent);
#else
  void*                      pIgnored);
#endif

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_Write(
  ADMXRC2_HANDLE             hCard,
  ADMXRC2_IOWIDTH            width,
  _ADMXRC2_DWORD             flags,
  _ADMXRC2_DWORD             localAddress,
  const void*                pData,
  unsigned long              length);

ADMXRC2_EXPORT ADMXRC2_STATUS
ADMXRC2_CALLING_CONVENTION
ADMXRC2_WriteConfig(
  ADMXRC2_HANDLE             hCard,
  unsigned long              locationIndex,
  _ADMXRC2_DWORD             value);

#ifdef __cplusplus
}
#endif

#endif
