#include <linux/kernel.h>
#include <linux/mm.h>

/*
** This file can be used to check whether the 4-argument 2.4.x style
** or the 5-argument 2.5.x style should be used for remap_page_range().
*/

static int
fops_mmap(
  struct file*           filp,
  struct vm_area_struct* vma)
{
  if (remap_page_range(vma->vm_start,
		       0,
		       1,
		       vma->vm_page_prot)) {
    /* Do nothing */
  }

  return 0;
}
