/*
** File: vpd.h  
** Project: ADMXRC2 module driver
** Purpose: Defines function prototypes for reading and writing VPD (Vital
**          Product Data).
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_ADMXRC2_VPD_H)
#define ADATA_ADMXRC2_VPD_H

#include <df.h>
#include "device.h"

extern void
syncVpdOnClose(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx);

extern DfIoStatus
ioctlReadConfig(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize,
  unsigned int outSize);

extern DfIoStatus
ioctlWriteConfig(
	Admxrc2DeviceContext* pDevCtx,
	Admxrc2ClientContext* pClCtx,
  void* pBuffer,
  unsigned int inSize);

#endif
