/*
** File: main.h  
** Project: ADMXRC2 module driver
** Purpose: Declare top-level functions of driver
**
** (C) Copyright Alpha Data 20013
*/

#ifndef _ADATA_ADMXRC2_MAIN_H
#define _ADATA_ADMXRC2_MAIN_H

#include <df.h>

#include "device.h"

extern boolean_t
admxrc2OnStart(
	DfDeviceObject* pDevObj,
  Admxrc2DeviceContext* pDevCtx,
	DfBusResources* pRawRes,
	DfBusResources* pTranslatedRes);

extern void
admxrc2OnStop(
	DfDeviceObject* pDevObj,
	Admxrc2DeviceContext* pDevCtx,
  boolean_t bCanTouchHardware);

extern boolean_t
admxrc2OnAdd(
	DfDeviceObject* pDevObj,
	Admxrc2DeviceContext* pDevCtx);

extern void
admxrc2OnRemove(
	DfDeviceObject* pDevObj,
	Admxrc2DeviceContext* pDevCtx);

extern boolean_t
admxrc2OnPowerQuery(
	DfDeviceObject* pDevObj,
	Admxrc2DeviceContext* pDevCtx,
  unsigned int currentState,
  unsigned int requestedState,
  boolean_t bIsShutdown);

extern void
admxrc2OnPowerSet(
	DfDeviceObject* pDevObj,
	Admxrc2DeviceContext* pDevCtx,
  unsigned int currentState,
  unsigned int newState,
  boolean_t bIsShutdown);

extern boolean_t
admxrc2DriverEntry(
	DfDriverObject* pDrvObj);

extern void
admxrc2DriverExit(
	DfDriverObject* pDrvObj);

#endif
