/*
** File: identify.c  
** Project: ADMXRC2 module driver
** Purpose: Identify device given model, bootstrap the the device context
**          appropriately for that model.
**
** (C) Copyright Alpha Data 2013
*/

#include <df.h>

#include "device.h"
#include "identify.h"
#include "model_boot.h"

boolean_t
admxrc2Identify(
  Admxrc2DeviceContext* pDevCtx,
  CoreModelType model)
{
  switch (model) {
#if defined(ADMXRC_DRIVER)
  case CoreModelAdmxrc:
  case CoreModelAdmxrcp:
    admxrc2BootstrapAdmxrc(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc2:
    admxrc2BootstrapAdmxrc2(pDevCtx);
    return TRUE;

  case CoreModelAdpdrc2:
    admxrc2BootstrapAdpdrc2(pDevCtx);
    return TRUE;

  case CoreModelAdpwrc2:
    admxrc2BootstrapAdpwrc2(pDevCtx);
    return TRUE;

  case CoreModelAdmxpl:
    admxrc2BootstrapAdmxpl(pDevCtx);
    return TRUE;

  case CoreModelAdmxp:
    admxrc2BootstrapAdmxp(pDevCtx);
    return TRUE;

  case CoreModelAdpxpi:
    admxrc2BootstrapAdpxpi(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc4lx:
  case CoreModelAdmxrc4sx:
    admxrc2BootstrapAdmxrc4(pDevCtx);
    return TRUE;

  case CoreModelAdcpxrc4lx:
    admxrc2BootstrapAdcpxrc4lx(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc4fx:
    admxrc2BootstrapAdmxrc4fx(pDevCtx);
    return TRUE;

  case CoreModelAdpexrc4fx:
    admxrc2BootstrapAdpexrc4fx(pDevCtx);
    return TRUE;

  case CoreModelAdmamc5a2:
    admxrc2BootstrapAdmamc5a2(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc5t1:
    admxrc2BootstrapAdmxrc5t1(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc5t2:
  case CoreModelAdmxrc5t2adv:
  case CoreModelAdmxrc5t2adv6:
  case CoreModelAdmxrc5t2advcc1:
    admxrc2BootstrapAdmxrc5t2(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc5tda1:
    admxrc2BootstrapAdmxrc5tda1(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc5lx:
    admxrc2BootstrapAdmxrc5lx(pDevCtx);
    return TRUE;

  case CoreModelAdmxrc5tz:
    admxrc2BootstrapAdmxrc5tz(pDevCtx);
    return TRUE;

  case CoreModelAdmpcie6s1:
    admxrc2BootstrapAdmpcie6s1(pDevCtx);
    return TRUE;
#endif

  default:
    break;
  }

	return FALSE; /* Failure */
}
