/*
** File: v6clksynth_common.h  
** Project: ADB3 core driver
** Purpose: Exports common functions for Virtex-6 MMCM clock synthesizer
**
** (C) Copyright Alpha Data 2011
**
** See XAPP878 for information about MMCM DRP registers.
*/

#ifndef _ADATA_CORE_V6CLKSYNTH_COMMON_H
#define _ADATA_CORE_V6CLKSYNTH_COMMON_H

#include <df.h>
#include "device.h"
#include "v6clksynth.h"

extern V6ClkSynthClockWordStatus
v6ClkSynthClockWord(
  uint32_t flags,
	uint32_t fRef,
	uint64_t fOutReq,
	uint64_t fOutMin,
	uint64_t fOutMax,
	CoreClockWord* pClockWord);

/* Must be called in thread context */
extern boolean_t
v6ClkSynthInit(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx,
  unsigned int refFreq,
  uint32_t* pFOut);

/* Must be called in thread context */
extern void
v6ClkSynthUninit(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx);

extern V6ClkSynthProgramStatus
v6ClkSynthProgram(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx,
  V6ClkSynthProgramRequest* pRequest,
  const CoreClockWord* pClockWord,
  V6ClkSynthProgramCallback* pCallback);

/* Must be called in thread context */
extern V6ClkSynthProgramStatus
v6ClkSynthProgramSync(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx,
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
v6ClkSynthSaveState(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx);

/* Must be called in thread context */
extern V6ClkSynthProgramStatus
v6ClkSynthRestoreState(
  Adb3CoreDeviceContext* pDevCtx,
  V6ClkSynthDeviceContext* pV6ClkSynthCtx);

/* Convenience functions */

extern ClockProgramStatus
v6ClkSynthMapProgramStatus(
  V6ClkSynthProgramStatus status);

extern ClockWordStatus
v6ClkSynthMapClockWordStatus(
  V6ClkSynthClockWordStatus status);

#endif
