/*
** File: v4clksynth.h  
** Project: ADB3 core driver
** Purpose: Definitions for Virtex-4 DCM clock synthesizer
**
** (C) Copyright Alpha Data 2013
*/

#ifndef _ADATA_CORE_V4CLKSYNTH_H
#define _ADATA_CORE_V4CLKSYNTH_H

#include <df.h>
#include "coreif.h"

struct _Adb3CoreDeviceContext;
struct _V4ClkSynthProgramRequest;
typedef struct _V4ClkSynthProgramRequest V4ClkSynthProgramRequest;
struct _V4ClkSynthProgramRequestSync;
typedef struct _V4ClkSynthProgramRequestSync V4ClkSynthProgramRequestSync;

typedef struct _V4ClkSynthDeviceContext {
  DfTimer timer;           /* Timer for checking that clock synthesizer programming was successful */
  struct { /* Used to save & restore state when powering down & up */
    CoreClockWord last;
    boolean_t bLastValid;
  } save;
} V4ClkSynthDeviceContext;

typedef enum _V4ClkSynthClockWordStatus {
  V4ClkSynthClockWordStatusSuccess = 0,
  V4ClkSynthClockWordStatusOutOfRange = 1,
  V4ClkSynthClockWordStatusGeneralFailure = 2
} V4ClkSynthClockWordStatus;

typedef enum _V4ClkSynthProgramStatus {
  V4ClkSynthProgramStatusSuccess = 0,
  V4ClkSynthProgramStatusHardwareError = 1,
  V4ClkSynthProgramStatusGeneralFailure = 2
} V4ClkSynthProgramStatus;

typedef void V4ClkSynthProgramCallback(struct _Adb3CoreDeviceContext* pDevCtx, V4ClkSynthDeviceContext* pV4ClkSynthCtx, V4ClkSynthProgramRequest* pRequest, V4ClkSynthProgramStatus status);

struct _V4ClkSynthProgramRequest {
  V4ClkSynthDeviceContext* pV4ClkSynthCtx;
  V4ClkSynthProgramCallback* pCallback;
  CoreClockWord clockWord;
};

struct _V4ClkSynthProgramRequestSync {
  V4ClkSynthProgramRequest request;
  DfEvent ev;
  V4ClkSynthProgramStatus status;
};

#endif
