/*
** File: si5338_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for programming the SI5338 clock generator.
**
** (C) Copyright Alpha Data 2011, 2015
*/

#ifndef _ADATA_CORE_SI5338_COMMON_H
#define _ADATA_CORE_SI5338_COMMON_H

#include "device.h"
#include "si5338.h"

extern Si5338ClockWordStatus
si5338ClockWord(
	uint32_t frequencyVCO,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
  boolean_t bAllowIntDivRange,
  CoreClockWord* pClockWord);

extern Si5338ClockWordStatus
si5338ClockWordStepping(
  Si5338DeviceContext* pSi5338Ctx,
  uint32_t flags,
  unsigned int msIndex,
	uint64_t frequencyReq,
	uint64_t frequencyMin,
	uint64_t frequencyMax,
  CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
si5338Init(
	I2cContext* pI2cCtx,
  Si5338DeviceContext* pSi5338Ctx,
  uint8_t busIndex,
  uint8_t deviceIndex);

/* Must be called in thread context */
void
si5338DumpRegisters(
  Si5338DeviceContext* pSi5338Ctx);

/*
** Find out what the VCO frequency is in the SI5338, and the
** initial frequencies of the 4 output clocks.
** Assumes that internal feedback is used.
**
** Must be called in thread context.
*/
boolean_t
si5338Interrogate(
  Si5338DeviceContext* pSi5338Ctx,
  uint32_t fRef,
  const uint32_t freqStep[4]);

/* Must be called in thread context */
extern boolean_t
si5338ConfigureFull(
  Adb3CoreDeviceContext* pDevCtx,
  Si5338DeviceContext* pSi5338Ctx,
  uint32_t vpdStart,
  uint32_t vpdLength);

/* Must be called in thread context */
extern Si5338Status
si5338ReadSync(
  Si5338DeviceContext* pSi5338Ctx,
  uint16_t regIndex,
  uint8_t* pVal8);

/* Must be called in thread context */
extern Si5338Status
si5338WriteMaskSync(
  Si5338DeviceContext* pSi5338Ctx,
  uint16_t regIndex,
  uint8_t mask8,
  uint8_t val8);

extern void
si5338Read(
  Si5338DeviceContext* pSi5338Ctx,
  Si5338Request* pRequest,
  uint16_t regIndex,
  Si5338Callback* pCallback,
  void* pContext);

extern void
si5338WriteMask(
  Si5338DeviceContext* pSi5338Ctx,
  Si5338Request* pRequest,
  uint16_t regIndex,
  uint8_t mask8,
  uint8_t val8,
  Si5338Callback* pCallback,
  void* pContext);

extern Si5338ProgramStatus
si5338ClockProgram(
  Si5338DeviceContext* pSi5338Ctx,
  Si5338ProgramRequest* pRequest,
  unsigned int msIndex, /* Multisynth index */
  const CoreClockWord* pClockWord,
  Si5338ProgramCallback* pCallback,
  void* pContext);

/* Must be called in thread context */
extern Si5338ProgramStatus
si5338ClockProgramSync(
  Si5338DeviceContext* pSi5338Ctx,
  unsigned int msIndex, /* Multisynth index */
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern Si5338ProgramStatus
si5338ClockProgramSteppingSync(
  Si5338DeviceContext* pSi5338Ctx,
  unsigned int msIndex, /* Multisynth index */
  const CoreClockWord* pClockWord);

/* Must be called in thread context */
extern void
si5338SaveState(
  Si5338DeviceContext* pSi5338Ctx);

/* Must be called in thread context */
extern Si5338ProgramStatus
si5338RestoreState(
  Si5338DeviceContext* pSi5338Ctx);

/* Convenience functions */

extern ClockProgramStatus
si5338MapProgramStatus(
  Si5338ProgramStatus status);

extern ClockWordStatus
si5338MapClockWordStatus(
  Si5338ClockWordStatus);

#endif
