/*
** File: resource.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for resource acquisition and release in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_RESOURCE_H)
#define ADATA_CORE_RESOURCE_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern void
coreAcquireAsync(
	void* pDevCtx,
    CoreTicket* pTicket,
    uint32_t flags,
    CoreAcquireCallback* pCallback);

extern CoreAcquireStatus
coreAcquireAsyncPoll(
	void* pDevCtx,
    CoreTicket* pTicket,
    uint32_t flags,
    CoreAcquireCallback* pCallback);

extern boolean_t
coreAcquireCancel(
	void* pDevCtx,
    CoreTicket* pTicket);

extern CoreAcquireStatus
coreAcquireInitialize(
  void* pInterfaceContext,
  CoreTicket* pTicket);

extern void
coreRelease(
	void* pDevCtx,
    CoreTicket* pTicket);

extern CoreAcquireStatus
coreAcquireSync(
	void* pDevCtx,
    CoreTicket* pTicket,
    uint32_t flags);

#if defined(DF_DBG_BUILD)
boolean_t
checkTicketValid(
  Adb3CoreDeviceContext* pDevCtx,
  CoreTicket* pTicket,
  uint8_t code,
  unsigned int index);
#else
# define checkTicketValid(pDevCtx, pTicket, code, index) (TRUE) /* No checks in non-debug driver */
#endif

#endif
