/*
** File: model_boot.h  
** Project: ADB3 core driver
** Purpose: Exports functions for model-specific bootstrapping of the device context.
**
** (C) Copyright Alpha Data 2009-2014
*/

#if !defined(ADATA_CORE_MODEL_BOOT_H)
#define ADATA_CORE_MODEL_BOOT_H

#include <df.h>

#include "device.h"

# if defined(ADMXRC_DRIVER)
extern void
adb3CoreBootstrapAdmxrc(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc2l(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc2(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpdrc2(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpwrc2(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxpl(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxp(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpxpi(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc4(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc4fx(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpexrc4fx(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5lx(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5t1(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5t2(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5tda1(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5lxa(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdcpxrc4lx(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmamc5a2(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc5tz(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdcbbp(
  Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmpcie6s1(
  Adb3CoreDeviceContext* pDevCtx);
#endif

# if defined(ADB3_DRIVER)
extern void
adb3CoreBootstrapGenericAdb3(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpexrc5t(
    Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc6tl(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc6t1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc6tge(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc6tadv8(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpexrc6t(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdpexrc6tadv(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc6tda1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc7k1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc7v1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmvpx37v2(
	Adb3CoreDeviceContext* pDevCtx);
#endif

extern void
adb3CoreBootstrapAdmxrc7z1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrc7z2(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrcku1(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrcku1P5(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmxrcku1P6(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmpcie7v3(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmpcieku3(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmpcie8v3(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3CoreBootstrapAdmpcie8k5(
	Adb3CoreDeviceContext* pDevCtx);

#endif
