/*
** File: interrupt.c  
** Project: ADB3 core driver
** Purpose: OS-independent functions related to handling of interrupts.
**
** (C) Copyright Alpha Data 2009-2010
*/

#include <df.h>

#include "corenotify.h"
#include "device.h"
#include "interrupt.h"

void
fpgaInterruptDpc(
  DfDpc* pDpc,
  void* pContext,
  void* pArg)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pContext;
  unsigned int targetIndex = (unsigned int)(uintptr_t)pArg;

  coreNotifyListeners(pDevCtx, &pDevCtx->notification.fpgaInterrupt[targetIndex]);
}
