/*
** File: icap_common.h  
** Project: ADB3 core driver
** Purpose: Exports functions for manipulating ICAP interface that is
**          present on certain Bridgeless models.
**
** (C) Copyright Alpha Data 2015
*/

#ifndef _ADATA_CORE_ICAP_COMMON_H
#define _ADATA_CORE_ICAP_COMMON_H

#include <df.h>
#include "device.h"
#include "admxrc6tx.h"

extern void
icapInit(
  IcapContext* pIcapContext,  /* Points to ICAP context structure */
  DfMemoryHandle hIcapRegs,   /* Memory handle for accessing ICAP register */
  IcapRegs* pIcapRegs,        /* Kernel-space pointer to ICAP register block */
  uint32_t delayCntFreqHz);   /* Delay counter frequency, in Hz */

extern void
icapUninit(
  IcapContext* pIcapContext,    /* Points to ICAP context structure */
  boolean_t bCanTouchHardware); /* FALSE => don't write to any registers */

extern void
icapSaveState(
  IcapContext* pIcapContext); /* Points to ICAP context structure */

extern void
icapRestoreState(
  IcapContext* pIcapContext); /* Points to ICAP context structure */

extern IprogResult
iprogAbort(
  IcapContext* pIcapContext); /* Points to ICAP context structure */

extern IprogResult
iprogScheduleFromNow(
  IcapContext* pIcapContext,  /* Points to ICAP context structure */
  uint32_t wbstarValue,       /* Value for WBSTAR register */
  uint32_t delayMs);          /* Countdown time, in milliseconds */

extern IprogResult
iprogScheduleOnStop(
  IcapContext* pIcapContext,  /* Points to ICAP context structure */
  uint32_t wbstarValue,       /* Value for WBSTAR register */
  uint32_t delayMs);          /* Countdown time, in milliseconds */

extern void
iprogStatus(
  IcapContext* pIcapContext,  /* Points to ICAP context structure */
  IprogScheduleState* pState, /* Indicates whether scheduled, and how */
  uint32_t* pWbstarValue,     /* Value for WBSTAR register */
  uint32_t* pDelayMs);        /* Remaining countdown time, in milliseconds */

#endif
