/*
** File: i2c_common.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for I2C bus access.
**
** (C) Copyright Alpha Data 2011
*/

#if !defined(ADATA_CORE_I2C_COMMON_H)
#define ADATA_CORE_I2C_COMMON_H

#include <df.h>
#include "device.h"
#include "i2c.h"

extern void
i2cCompletedRoutine(
  DfDpc* pDpc,
  void* pContext,
  void* pArg);

extern void
i2cInit(
  I2cContext* pI2cCtx,
  DfInterruptObject* pInterruptObject,
  I2cStartMethod* pI2cStart,
  I2cPollMethod* pI2cPoll,
  void* pContext);

extern void
i2cUninit(
  I2cContext* pI2cCtx);

extern void
i2cRead(
  I2cContext* pI2cCtx,
  I2cRequest* pRequest,
  uint8_t bus,
  uint8_t slot,
  uint8_t address,
  I2cCallback* pCallback,
  void* pContext);

extern void
i2cWrite(
  I2cContext* pI2cCtx,
  I2cRequest* pRequest,
  uint8_t bus,
  uint8_t slot,
  uint8_t address,
  uint8_t data,
  I2cCallback* pCallback,
  void* pContext);

extern I2cStatus
i2cReadSync(
  I2cContext* pI2cCtx,
  uint8_t bus,
  uint8_t device,
  uint8_t address,
  uint8_t* pData);

extern I2cStatus
i2cWriteSync(
  I2cContext* pI2cCtx,
  uint8_t bus,
  uint8_t device,
  uint8_t address,
  uint8_t data);

extern void
i2cDebugScanBus(
  I2cContext* pI2cCtx,
  uint8_t bus);

extern void
i2cDebugDumpDevice(
  I2cContext* pI2cCtx,
  uint8_t bus,
  uint8_t slot);

#endif
