/*
** File: corewindow.h  
** Project: ADB3 core driver
** Purpose: Defines prototypes for Core Interface Window functions.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(ADATA_CORE_COREWINDOW_H)
#define ADATA_CORE_COREWINDOW_H

#include <df.h>
#include "coreif.h"

extern unsigned int
coreGetNumWindow(
  void* pInterfaceContext);

extern CoreWindowStatus
coreGetWindowInfo(
  void* pInterfaceContext,
  unsigned int windowIndex,
  CoreWindowInfo* pInfo);

extern CoreWindowAddressStatus
coreGetWindowAddress(
  void* pInterfaceContext,
  unsigned int windowIndex,
  size_t offset,
  size_t length,
  void** pKernelAddress);

extern CoreWindowConfigStatus
coreGetWindowConfig(
  void* pInterfaceContext,
  unsigned int windowIndex,
  CoreWindowConfig* pConfig);

extern CoreWindowConfigStatus
coreSetWindowConfig(
  void* pInterfaceContext,
  unsigned int windowIndex,
  uint32_t flags, /* See COREWINDOWCONFIG_xxx flags */
  const CoreWindowConfig* pConfig);

#endif
