/*
** File: corevpd.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for VPD read and write in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_COREVPD_H)
#define ADATA_CORE_COREVPD_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern CoreModelType
coreGetModel(
  void* pInterfaceContext);

extern const void*
coreGetVpdPointer(
  void* pInterfaceContext);

extern CoreVpdStatus
coreVpdRead(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  size_t address,
  size_t length,
  void* pBuffer);

extern CoreVpdStatus
coreVpdSync(
  void* pInterfaceContext,
  CoreTicket* pTicket);

extern CoreVpdStatus
coreVpdWrite(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  size_t address,
  size_t length,
  const void* pBuffer);

#endif
