/*
** File: corevpd.c  
** Project: ADB3 core driver
** Purpose: Implements functions for VPD read and write in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#include <df.h>

#include "corevpd.h"

CoreModelType
coreGetModel(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.model;
}

const void*
coreGetVpdPointer(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (pDevCtx->info.vpd.bValid) {
    return pDevCtx->info.vpd.pData;
  } else {
    return NULL;
  }
}

DF_ATTR_PASSIVE_CONTEXT
CoreVpdStatus
coreVpdRead(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  size_t address,
  size_t length,
  void* pBuffer)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  dfAssertPassiveContext();

  if (NULL == pDevCtx->methods.pReadWriteVpd) {
    return CoreVpdNotPresent;
  }
  if (address + length < address) {
    /* Region wraps around */
    return CoreVpdInvalidRegion;
  }
  if (address + length > pDevCtx->info.bootstrap.vpdLength) {
    return CoreVpdInvalidRegion;
  }
  address += pDevCtx->info.bootstrap.vpdOffset;
  return pDevCtx->methods.pReadWriteVpd(pDevCtx, FALSE, address, length, pBuffer);
}

DF_ATTR_PASSIVE_CONTEXT
CoreVpdStatus
coreVpdSync(
  void* pInterfaceContext,
  CoreTicket* pTicket)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  dfAssertPassiveContext();

  if (NULL == pDevCtx->methods.pSyncVpd) {
    return CoreVpdSuccess;
  }
  return pDevCtx->methods.pSyncVpd(pDevCtx);
}

DF_ATTR_PASSIVE_CONTEXT
CoreVpdStatus
coreVpdWrite(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  size_t address,
  size_t length,
  const void* pBuffer)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;
  boolean_t bEnableVpdWrite = FALSE;

  dfAssertPassiveContext();

  if (NULL == pDevCtx->methods.pReadWriteVpd) {
    return CoreVpdNotPresent;
  }

  if (address + length < address) {
    /* Region wraps around */
    return CoreVpdInvalidRegion;
  }
  if (address + length > pDevCtx->info.bootstrap.vpdLength) {
    return CoreVpdInvalidRegion;
  }
  address += pDevCtx->info.bootstrap.vpdOffset;
  dfParameterGetBoolean(pDevCtx->pDevObj->pDrvObj, "EnableVpdWrite", &bEnableVpdWrite);
  if (!bEnableVpdWrite) {
    return CoreVpdWriteFailed;
  }
  return pDevCtx->methods.pReadWriteVpd(pDevCtx, TRUE, address, length, (void*)pBuffer);
}
