/*
** File: coresensor.c  
** Project: ADB3 core driver
** Purpose: Implements functions for system monitor sensors in Core Interface.
**
** (C) Copyright Alpha Data 2010
*/

#include <df.h>

#include "coresensor.h"

unsigned int
coreGetNumSensor(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.bootstrap.numSensor;
}

CoreSensorStatus
coreGetSensorInfo(
  void* pInterfaceContext,
  unsigned int sensorIndex,
  CoreSensorInfo* pSensorInfo)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (sensorIndex >= pDevCtx->info.bootstrap.numSensor) {
    return CoreSensorInvalidIndex;
  } else {
    *pSensorInfo = pDevCtx->info.sensor[sensorIndex];
    return CoreSensorSuccess;
  }
}

CoreSensorStatus
coreReadSensor(
  void* pInterfaceContext,
  unsigned int sensorIndex,
  CoreSensorValue* pSensorValue)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (sensorIndex >= pDevCtx->info.bootstrap.numSensor) {
    return CoreSensorInvalidIndex;
  } else {
    return pDevCtx->methods.pReadSensor(pDevCtx, sensorIndex, pSensorValue);
  }
}
