/*
** File: coremodule.c  
** Project: ADB3 core driver
** Purpose: Core Interface I/O module functions.
**
** (C) Copyright Alpha Data 2010
*/

#include <df.h>
#include "device.h"
#include "coremodule.h"

unsigned int
coreGetNumIoModule(
  void* pInterfaceContext)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  return pDevCtx->info.bootstrap.numIoModule;
}

CoreIoModuleStatus
coreGetIoModuleInfo(
  void* pInterfaceContext,
  unsigned int ioModuleIndex,
  CoreIoModuleInfo* pIoModuleInfo)
{
  Adb3CoreDeviceContext* pDevCtx = (Adb3CoreDeviceContext*)pInterfaceContext;

  if (ioModuleIndex >= pDevCtx->info.bootstrap.numIoModule) {
    return CoreIoModuleInvalidIndex;
  } else {
    *pIoModuleInfo = pDevCtx->info.ioModule[ioModuleIndex];
    return CoreIoModuleSuccess;
  }
}
