/*
** File: corefpga.h  
** Project: ADB3 core driver
** Purpose: Defines prototypes for Core Interface target FPGA functions.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_COREFPGA_H)
#define ADATA_CORE_COREFPGA_H

#include <df.h>
#include "coreif.h"

extern CoreFpgaControlStatus
coreFpgaControl(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int targetIndex,
  CoreFpgaControlOp operation,
  boolean_t* pbValue);

extern CoreFpgaSelectMapStatus
coreFpgaSelectMap(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int targetIndex,
  boolean_t bWrite,
  size_t length,
  void* pBuffer);

extern unsigned int
coreGetNumTargetFpga(
  void* pInterfaceContext);

#endif
