/*
** File: coreclock.h  
** Project: ADB3 core driver
** Purpose: Defines function prototypes for Clock generators in Core Interface.
**
** (C) Copyright Alpha Data 2009-2010
*/

#if !defined(ADATA_CORE_CORECLOCK_H)
#define ADATA_CORE_CORECLOCK_H

#include <df.h>
#include "device.h"
#include "coreif.h"

extern void
onClockProgramDone(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int clockIndex,
  ClockProgramStatus status);

extern CoreClockStatus
coreClockGetFreq(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int clockIndex,
  uint64_t* pActualFrequency);

extern CoreClockStatus
coreClockProgram(
  void* pInterfaceContext,
  CoreTicket* pTicket,
  unsigned int clockIndex,
  const CoreClockWord* pClockWord,
  CoreClockProgCallback* pCallback,
  void* pContext);

extern CoreClockStatus
coreClockTestFreq(
  void* pInterfaceContext,
  unsigned int clockIndex,
  uint32_t flags,
  uint64_t frequencyReq,
  uint64_t frequencyMin,
  uint64_t frequencyMax,
  CoreClockWord* pClockWord);

extern unsigned int
coreGetNumClockGen(
  void* pInterfaceContext);

#endif
