/*
** File: avr_sensor.h  
** Project: ADB3 core driver
** Purpose: Exports functions relating to AVR uC sensors
**
** (C) Copyright Alpha Data 2012
*/

#ifndef _ADATA_CORE_AVR_SENSOR_H
#define _ADATA_CORE_AVR_SENSOR_H

#include "device.h"

typedef struct _AvrVoltageScaling {
  unsigned int fieldOffset; /* Offset of field in sensor data block */
  uint16_t fieldMask;       /* Value for masking raw value */
  boolean_t bFieldSigned;   /* TRUE => interpret raw ADC as signed (two's complement) */
  int32_t factor;           /* Fixed point 6.26, where 0x04000000 => 1, 0x02000000 => 0.5, 0xFE000000 => -0.5 etc. */
} AvrVoltageScaling;

typedef struct _AvrCurrentScaling {
  unsigned int fieldOffset; /* Offset of field in sensor data block */
  uint16_t fieldMask;       /* Value for masking raw value */
  boolean_t bFieldSigned;   /* TRUE => interpret raw ADC as signed (two's complement) */
  int32_t factor;           /* Fixed point 6.26, where 0x04000000 => 1, 0x02000000 => 0.5, 0xFE000000 => -0.5 etc. */
} AvrCurrentScaling;

typedef struct _AvrTempScaling {
  unsigned int fieldOffset; /* Offset of field in sensor data block */
  uint16_t fieldMask;       /* Value for masking shifted raw value */
  boolean_t bFieldSigned;   /* TRUE => interpret raw ADC as signed (two's complement) */
  int32_t factor;           /* Fixed point 12.20, where 0x00100000 => 1, 0x00080000 => 0.5, 0xFFF80000 => -0.5 etc. */
  int32_t offset;           /* Fixed point 16.16, where 0x00010000 => 1, 0x00008000 => 0.5, 0xFFFF8000 => -0.5 etc. */
} AvrTempScaling;

typedef struct _AvrMiscScaling {
  struct {
    unsigned int fieldOffset;  /* Offset of field in sensor data block */
  } manufTime;
  struct {
    unsigned int fieldOffset;  /* Offset of field in sensor data block */
    boolean_t bSillyByteOrder; /* TRUE => Byte order is 23:16, then 7:0, then 15:8 */
  } eventCount;
} AvrMiscScaling;

extern CoreSensorStatus
avrSensorCurrentRead(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int avrCurrentIndex,
  AvrCurrentScaling* pScaling,
  unsigned int count,
  CoreSensorValue* pReading);

extern CoreSensorStatus
avrSensorMiscRead(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int avrMiscIndex,
  AvrMiscScaling* pScaling,
  CoreSensorValue* pReading);

extern CoreSensorStatus
avrSensorTempRead(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int avrTempIndex,
  AvrTempScaling* pScaling,
  unsigned int count,
  CoreSensorValue* pReading);

extern CoreSensorStatus
avrSensorVoltageRead(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int avrVoltageIndex,
  AvrVoltageScaling* pScaling,
  unsigned int count,
  CoreSensorValue* pReading);

#endif
