/*
** File: adpexrc6tadv.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADPE-XRC-6T-ADV.
**
** (C) Copyright Alpha Data 2012
**
** Notes:
**
** 1. The VPD is propagated in its entirety to the controller, target FPGA 0
**    & target FPGA 1.
**
** 2. The AVR microcontroller is connected only to the controller, so sensors
**    can be read only through the controller.
*/

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#ifndef _ADATA_CORE_ADPEXRC6TADV_H
#define _ADATA_CORE_ADPEXRC6TADV_H

/* ---------------------------------------------------------------
** COMMON DEFINITIONS
** --------------------------------------------------------------- */

/* Always LITTLE ENDIAN in hardware */
#pragma pack(1)
typedef struct _ModelRegsAdpexrc6tadv {
  uint32_t pcbRev;             /* 0x0000 */
	uint32_t pwrStat;            /* 0x0004 */
	uint32_t buildDate;          /* 0x0008 */
	uint32_t buildTime;          /* 0x000C */
  uint32_t _reserved1[4];      /* 0x0010 */
  struct {
	  uint8_t  selectMap[4];     /* 0x0020 */
	  uint32_t ctl;              /* 0x0024 */
    uint32_t read;             /* 0x0028 */
  } fpga0; /* Controller only */
  uint32_t serial;             /* 0x002C */
	uint32_t intCtl;             /* 0x0030 */
	uint32_t intStat;            /* 0x0034 */
	uint32_t _reserved2[2];      /* 0x0038 */
  FlashRegsAdmxrc6tx flash0;   /* 0x0040, Controller only */
  struct {
    uint32_t gpioBToT;         /* 0x0050 */
    uint32_t gpioTToT;         /* 0x0054 */
	  uint32_t _reserved4[2];    /* 0x0058 */
  } serSb0; /* Controller only */
  struct {
    uint32_t recovery;         /* 0x0060 */
    uint32_t stat;             /* 0x0064 */
    uint32_t error;            /* 0x0068 */
	  uint32_t _reserved5[1];    /* 0x006C */
  } mptl0; /* Controller only */
	uint32_t _reserved6[16];     /* 0x0070 */
  struct {
    uint32_t ctlStat;          /* 0x00B0 */
    uint32_t _reserved7[3];    /* 0x00B4 */
  } avr; /* Controller only */
  struct {
	  uint8_t  selectMap[4];     /* 0x00C0 */
	  uint32_t ctl;              /* 0x00C4 */
    uint32_t read;             /* 0x00C8 */
  } fpga1; /* Controller only */
  uint32_t _reserved8[1];      /* 0x00CC */
  FlashRegsAdmxrc6tx flash1;   /* 0x00D0, Controller only */
  struct {
    uint32_t gpioBToT;         /* 0x00E0 */
    uint32_t gpioTToT;         /* 0x00E4 */
	  uint32_t _reserved9[2];    /* 0x00E8 */
  } serSb1; /* Controller only */
  uint32_t _reserved10[0x1C4]; /* 0x00F0 */
  uint8_t vpd[0x100];          /* 0x0800 */
  uint32_t _reserved11[0x40];  /* 0x0900 */
  uint8_t sensor[0x200];       /* 0x0A00, Controller only */
  uint32_t _reserved12[0x100]; /* 0x0C00 */
} ModelRegsAdpexrc6tadv;       /* 0x1000 */
#pragma pack()

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpexrc6tadvRev0 {
	uint16_t version;          /* 0x00 Revision of this structure (0) */
	uint16_t length;           /* 0x02 Length of this structure including checksum */
  struct {
    uint32_t serial;         /* 0x04 Serial number for board as a whole */
    uint32_t modifications;  /* 0x08 See ADPEXRC6TADV_VPD_MOD_* below for values */
    uint8_t tempGrade;       /* 0x0C See ADPEXRC6TADV_VPD_TEMPGRADE_* below for values */
    uint8_t _reserved1;      /* 0x0D */
    uint8_t pcbRev;          /* 0x0E Value is 0xAB where A is major, B is minor */
    uint8_t _reserved2;      /* 0x0F */
    uint32_t si5338Ref;      /* 0x10 Reference clock frequency for SI5338s, in Hz */
    uint32_t _reserved3[3];  /* 0x14 */
  } board; /* 28 bytes */
  struct {
    struct {
		  uint16_t speed;        /* 0x20+i*8, 0x50+i*8 Max. operating freq. for DDR3 SDRAM banks 0 - 3 (or 4 - 7), in 100 kHz units */
		  uint8_t	 order;        /* 0x22+i*8, 0x52+i*8 Log base 2 of DDR3 SDRAM banks 0 - 3 (or 4 - 7) word size */
      uint8_t  _reserved4;   /* 0x23+i*8, 0x53+i*8 */
      uint16_t link;         /* 0x24+i*8, 0x54+i*8 Byte offset in VPD of extended info */
      uint16_t _reserved5;   /* 0x26+i*8, 0x56+i*8 */
    } sdram[4];
    struct {
      uint8_t stepping[8];   /* 0x40, 0x70 NUL-term string of stepping level, e.g. "ES" */
      uint8_t speedGrade[4]; /* 0x48, 0x78 NUL-term string of speed grade, e.g. "1" */
      uint16_t device;       /* 0x4C, 0x7C Device code, e.g. 171 for 6VLX240T */
    } fpga;
    uint8_t advFitted;       /* 0x4E, 0x7E Bitmask of ADV devices fitted (bit 0 = 1 => ADV0 (or ADV4) fitted */
    uint8_t _reserved6;      /* 0x4F, 0x7F */
  } target[2];
  uint8_t checksum;          /* 0x80       This MUST ALWAYS be the last member in the struct */
} VpdAdpexrc6tadvRev0;       /* 0x81 bytes in total */
#pragma pack()

/* Values for VpdAdpexrc6tadvRev0::modifications */

/* Values for VpdAdpexrc6tadvRev0::fpga::tempGrade */
#define ADPEXRC6TADV_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADPEXRC6TADV_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADPEXRC6TADV_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* ---------------------------------------------------------------
** TARGET DEFINITIONS
** --------------------------------------------------------------- */

#define ADPEXRC6TADVTGT_NUM_DMA_CHANNEL 4U /* Maximum number - can be less; actual number detected during hardware init. */

/* Fields for ModelRegsAdxrc6tx::intCtl */
#define ADPEXRC6TADVTGT_V_INTCTL_LEVELBITS 0U

/* ---------------------------------------------------------------
** CONTROLLER DEFINITIONS
** --------------------------------------------------------------- */

#define ADPEXRC6TADVCTL_NUM_DMA_CHANNEL 4U /* Maximum number - can be less; actual number detected during hardware init. */

#define ADPEXRC6TADVCTL_NUM_TARGET_FPGA 2U /* Number of target FPGAs */

/* Fields for ModelRegsAdxrc6tx::intCtl */
#define ADPEXRC6TADVCTL_V_INTCTL_ADVRXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt enable */
#define ADPEXRC6TADVCTL_V_INTCTL_ADVTXE     DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt enable */
#define ADPEXRC6TADVCTL_V_INTCTL_LS_ADVRXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR uC RX FIFO not empty interrupt is level-sensitive */
#define ADPEXRC6TADVCTL_V_INTCTL_LS_ADVTXE  DF_VAL32S(0x1U, 14, 1) /* 1 => AVR uC TX FIFO empty interrupt is level-sensitive */

#define ADPEXRC6TADVCTL_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADPEXRC6TADVCTL_V_INTCTL_LS_ADVRXNE | ADPEXRC6TADVCTL_V_INTCTL_LS_ADVTXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADPEXRC6TADVCTL_V_INTSTAT_ADVRXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt active */
#define ADPEXRC6TADVCTL_V_INTSTAT_ADVTXE    DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt active */

#define ADPEXRC6TADVCTL_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADPEXRC6TADVCTL_V_INTSTAT_ADVRXNE | ADPEXRC6TADVCTL_V_INTSTAT_ADVTXE)

/* AVR uC NV memory info */
#define ADPEXRC6TADVCTL_AVR_FLASH_PAGE_SIZE    (0x100U) /* Size in bytes of a Flash memory page in AVR uC */
#define ADPEXRC6TADVCTL_AVR_FLASH_SIZE       (0x10000U) /* Size in bytes of Flash memory in AVR uC */
#define ADPEXRC6TADVCTL_AVR_FLASH_VPD_OFFSET  (0xFF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
