/*
** File: admxrc7z1.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-7Z1.
**
** (C) Copyright Alpha Data 2014
*/

#ifndef _ADATA_CORE_ADMXRC7Z1_H
#define _ADATA_CORE_ADMXRC7Z1_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADMXRC7Z1_NUM_DMA_CHANNEL (4)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc7z1Rev0 {
	uint16_t boardType;        /* 0x00 Model code (0x10F) */
	uint16_t version;          /* 0x02 Revision of this structure (0) */
	uint16_t length;           /* 0x04 Length of this structure including checksum */
  uint16_t _reserved1;       /* 0x06 (Reserved)*/
	uint32_t serial;           /* 0x08 Board serial number */
	uint32_t modifications;    /* 0x0C Modifications bitmask; see definitions below */
	uint32_t si5338Ref;        /* 0x10 Frequency of SI5338 reference oscillator, in Hz */
	uint32_t si5338Output1;    /* 0x14 Frequency to configure for SI5338 output 1, in Hz */
  uint32_t _reserved2;       /* 0x18 (Reserved)*/
	struct {
		uint8_t	 order;          /* 0x1C, 0x1E Log base 2 of size in words */
    uint8_t  _reserved3;     /* 0x1D, 0x1F */
	} flash[2];
	struct { /* PS DDR3 SDRAM bank */
		uint16_t speed;          /* 0x20 In units of 100 kHz */
		uint8_t	 order;          /* 0x22 Log base 2 of size in words */
    uint8_t  _reserved4;     /* 0x23 */
    uint16_t link;           /* 0x24 Byte offset in VPD of extended info */
    uint16_t _reserved5;     /* 0x26 */
	} sdramPS;
	struct { /* Fabric DDR3 SDRAM bank */
		uint16_t speed;          /* 0x28, 0x30 In units of 100 kHz */
		uint8_t	 order;          /* 0x2A, 0x32 Log base 2 of size in words */
    uint8_t  _reserved6;     /* 0x2B, 0x33 (Reserved) */
    uint16_t link;           /* 0x2C, 0x34 Byte offset in VPD of extended info */
    uint16_t _reserved7;     /* 0x2E, 0x36 (Reserved) */
	} sdramFabric[2];
  struct {
    uint8_t  stepping[8];    /* 0x38 Stepping level of target FPGA */
    uint8_t  speedGrade[4];  /* 0x40 Speed grade of target FPGA */
    uint16_t device;         /* 0x44 Device code of target FPGA */
    uint8_t  tempGrade;      /* 0x46 Temperature grade of target FPGA; see definitions below */
    uint8_t  _reserved8;     /* 0x47 */
  } fpga;
	uint8_t  pcbRev;           /* 0x48 PCB revision 0xAB where A is major, B is minor */
	uint8_t  cpldRev;          /* 0x49 CPLD revision 0xAB where A is major, B is minor */
  uint8_t  _reserved9;       /* 0x4A */ 
  uint8_t  checksum;         /* 0x4B This MUST ALWAYS be the last member in the struct */
} VpdAdmxrc7z1Rev0;
#pragma pack()

/* Values for VpdAdmxrc7z1Rev0::modifications */
#define ADMXRC7Z1_VPD_MOD_NOTFITTED_XMC_PN6 (0x1U << 0U) /* XMC P16 connector NOT fitted */
#define ADMXRC7Z1_VPD_MOD_NOTFITTED_XMC_PN4 (0x1U << 1U) /* PMC Pn4 connector NOT fitted */
#define ADMXRC7Z1_VPD_MOD_NOTFITTED_uUSB    (0x1U << 2U) /* microUSB connector NOT fitted */
#define ADMXRC7Z1_VPD_MOD_NOTFITTED_uSD     (0x1U << 3U) /* microSD connector NOT fitted */

/* Values for VpdAdmxrc7z1Rev0::fpga::tempGrade */
#define ADMXRC7Z1_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRC7Z1_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRC7Z1_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */

#define ADMXRC7Z1_V_INTCTL_LEVELBITS (0)

#define ADMXRC7Z1_V_INTSTAT_LEVELBITS (0)

/* AVR uC NV memory info */
#define ADMXRC7Z1_AVR_FLASH_PAGE_SIZE    (0x200U) /* Size in bytes of a Flash memory page in AVR uC */
#define ADMXRC7Z1_AVR_FLASH_SIZE       (0x20000U) /* Size in bytes of Flash memory in AVR uC */
#define ADMXRC7Z1_AVR_FLASH_VPD_OFFSET (0x1FF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
