/*
** File: admxrc7v1.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-7V1.
**
** (C) Copyright Alpha Data 2012
*/

#ifndef _ADATA_CORE_ADMXRC7V1_H
#define _ADATA_CORE_ADMXRC7V1_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"

#define ADMXRC7V1_NUM_DMA_CHANNEL (4)

/* Number of clocks programmable via AVR (some may be not be user-programmable) */
#define ADMXRC7V1_NUM_AVR_CLOCK (4)
/* Number of user-programmable clocks programmable via AVR */
#define ADMXRC7V1_NUM_AVR_USER_CLOCK (1)

/* Offset of XRM Status field in sensor data block in model-specific registers */
#define ADMXRC7V1_SENSOR_OFFSET_XRMSTATUS (0x33U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc7v1Rev0 {
	uint16_t version;          /* 0x00 Revision of this structure (0) */
	uint16_t length;           /* 0x02 Length of this structure including checksum */
	uint32_t serial;           /* 0x04 Board serial number */
	uint32_t modifications;    /* 0x08 Modifications bitmask; see definitions below */
	uint32_t si5338Ref;        /* 0x0C Frequency of SI5338 reference oscillator, in Hz */
	uint32_t si5338Output1;    /* 0x10 Frequency to configure for SI5338 output 1, in Hz */
  uint32_t _reserved1;       /* 0x14 */
	struct {
		uint16_t speed;          /* 0x18, 0x20 In units of 100 kHz */
		uint8_t	 order;          /* 0x1A, 0x22 Log base 2 of size in words */
    uint8_t  _reserved2;     /* 0x1B, 0x23 */
    uint16_t link;           /* 0x1C, 0x24 Byte offset in VPD of extended info */
    uint16_t _reserved3;     /* 0x1E, 0x26 */
	} sdram[4];
  struct {
    uint8_t  stepping[8];    /* 0x28 Stepping level of target FPGA */
    uint8_t  speedGrade[4];  /* 0x30 Speed grade of target FPGA */
    uint16_t device;         /* 0x34 Device code of target FPGA */
    uint8_t  tempGrade;      /* 0x36 Temperature grade of target FPGA; see definitions below */
    uint8_t  _reserved4;     /* 0x37 */
  } fpga;
	uint8_t  pcbRev;           /* 0x38 PCB revision 0xAB where A is major, B is minor */
	uint8_t  cpldRev;          /* 0x39 CPLD revision 0xAB where A is major, B is minor */
  uint8_t  _reserved5;       /* 0x3A */ 
  uint8_t  checksum;         /* 0x3B This MUST ALWAYS be the last member in the struct */
} VpdAdmxrc7v1Rev0;
#pragma pack()

/* Values for VpdAdmxrc7v1Rev0::modifications */
#define ADMXRC7V1_VPD_MOD_NOTFITTED_XMC_PN6 (0x1U << 0U) /* XMC P16 connector NOT fitted */
#define ADMXRC7V1_VPD_MOD_NOTFITTED_XMC_PN4 (0x1U << 1U) /* PMC Pn4 connector NOT fitted */
#define ADMXRC7V1_VPD_MOD_GIGE_PN6          (0x1U << 2U) /* Has Gigabit Ethernet instead of 4 Pn6 lanes */
#define ADMXRC7V1_VPD_MOD_MGTREFCLK_PN6     (0x1U << 3U) /* Has an MGT reference clock on 2 Pn6 pins */

/* Values for VpdAdmxrc7v1Rev0::fpga::tempGrade */
#define ADMXRC7V1_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRC7V1_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRC7V1_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMXRC7V1_V_INTCTL_ADVRXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt enable */
#define ADMXRC7V1_V_INTCTL_ADVTXE     DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt enable */
#define ADMXRC7V1_V_INTCTL_LS_ADVRXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR uC RX FIFO not empty interrupt is level-sensitive */
#define ADMXRC7V1_V_INTCTL_LS_ADVTXE  DF_VAL32S(0x1U, 14, 1) /* 1 => AVR uC TX FIFO empty interrupt is level-sensitive */

#define ADMXRC7V1_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADMXRC7V1_V_INTCTL_LS_ADVRXNE | ADMXRC7V1_V_INTCTL_LS_ADVTXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADMXRC7V1_V_INTSTAT_ADVRXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt active */
#define ADMXRC7V1_V_INTSTAT_ADVTXE    DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt active */

#define ADMXRC7V1_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADMXRC7V1_V_INTSTAT_ADVRXNE | ADMXRC7V1_V_INTSTAT_ADVTXE)

/* AVR uC NV memory info */
#define ADMXRC7V1_AVR_FLASH_PAGE_SIZE    (0x200U) /* Size in bytes of a Flash memory page in AVR uC */
#define ADMXRC7V1_AVR_FLASH_SIZE       (0x20000U) /* Size in bytes of Flash memory in AVR uC */
#define ADMXRC7V1_AVR_FLASH_VPD_OFFSET (0x1FF00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
