/*
** File: admxrc6tadv8.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-6T-ADV8.
**
** (C) Copyright Alpha Data 2011
*/

#ifndef _ADATA_CORE_ADMXRC6TADV8_H
#define _ADATA_CORE_ADMXRC6TADV8_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tl.h"
#include "admxrc6tx.h"

#define ADMXRC6TADV8_NUM_DMA_CHANNEL (4U) /* Maximum number - can be less; actual number detected during hardware init. */

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc6tadv8Rev0 {
	uint16_t version;         /* 0x00 Revision of this structure (0) */
	uint16_t length;          /* 0x02 Length of this structure including checksum */
	uint32_t serial;          /* 0x04 Serial number */
	uint32_t modifications;   /* 0x08 Modifications bitmask */
  uint32_t idelayRef;       /* 0x0C IDELAY reference clock oscillator frequency */
	uint32_t mgt1Ref;         /* 0x10 MGT reference clock 1 frequency */
	uint32_t mgt2Ref;         /* 0x14 MGT reference clock 2 frequency */
	struct {
		uint16_t speed;         /* 0x18, 0x20, 0x28, 0x30 In units of 100 kHz */
		uint8_t	 order;         /* 0x1A, 0x22, 0x2A, 0x32 Log base 2 of size in words */
    uint8_t  _reserved1;
    uint16_t link;          /* 0x1C, 0x24, 0x2C, 0x34 Byte offset in VPD of extended info */
    uint16_t _reserved2;
	} sdram[4];
  uint32_t adv8NotFitted;   /* 0x38 Bitmask of ADV8 devices not fitted; bit 0 => ADV8 0 not fitted, ..., bit 3 => ADV8 3 not fitted */
  struct {
    uint8_t  stepping[8];   /* 0x3C */
    uint8_t  speedGrade[4]; /* 0x44 */
    uint16_t device;        /* 0x48 */
    uint8_t  tempGrade;     /* 0x4A */
    uint8_t  _reserved1;    /* 0x4B */
  } fpga;
	uint8_t  pcbRev;          /* 0x4C PCB revision as 0xAB where A = major, B = minor */
  uint8_t  checksum;        /* 0x4D This MUST ALWAYS be the last member in the struct */
} VpdAdmxrc6tadv8Rev0;
#pragma pack()

/* Values for VpdAdmxrc6tadv8Rev0::modifications */
#define ADMXRC6TADV8_VPD_MOD_NOTFITTED_XMC_PN6 (0x1U << 0U) /* XMC P16 connector NOT fitted */
#define ADMXRC6TADV8_VPD_MOD_NOTFITTED_OPTXCV  (0x1U << 1U) /* Front-panel optical transceivers NOT fitted */

/* Values for VpdAdmxrc6tadv8Rev0::fpga::tempGrade */
#define ADMXRC6TADV8_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6TL_VPD_TEMPGRADE_COMMERCIAL
#define ADMXRC6TADV8_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6TL_VPD_TEMPGRADE_INDUSTRIAL
#define ADMXRC6TADV8_VPD_TEMPGRADE_EXTENDED    ADMXRC6TL_VPD_TEMPGRADE_EXTENDED    /* Added in ADM-XRC-6T1 VPD spec. v1.1 */

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMXRC6TADV8_V_INTCTL_ADVRXNE    DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt enable */
#define ADMXRC6TADV8_V_INTCTL_ADVTXE     DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt enable */
#define ADMXRC6TADV8_V_INTCTL_LS_ADVRXNE DF_VAL32S(0x1U, 13, 1) /* 1 => AVR uC RX FIFO not empty interrupt is level-sensitive */
#define ADMXRC6TADV8_V_INTCTL_LS_ADVTXE  DF_VAL32S(0x1U, 14, 1) /* 1 => AVR uC TX FIFO empty interrupt is level-sensitive */

#define ADMXRC6TADV8_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL | ADMXRC6TADV8_V_INTCTL_LS_ADVRXNE | ADMXRC6TADV8_V_INTCTL_LS_ADVTXE)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADMXRC6TADV8_V_INTSTAT_ADVRXNE   DF_VAL32S(0x1U, 5, 1)  /* AVR uC RX FIFO not empty interrupt active */
#define ADMXRC6TADV8_V_INTSTAT_ADVTXE    DF_VAL32S(0x1U, 6, 1)  /* AVR uC TX FIFO empty interrupt active */

#define ADMXRC6TADV8_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS | ADMXRC6TADV8_V_INTSTAT_ADVRXNE | ADMXRC6TADV8_V_INTSTAT_ADVTXE)

/* AVR uC NV memory info */
#define ADMXRC6TADV8_AVR_FLASH_PAGE_SIZE   (0x100U) /* Size in bytes of a Flash memory page in AVR uC */
#define ADMXRC6TADV8_AVR_FLASH_SIZE       (0x4000U) /* Size in bytes of Flash memory in AVR uC */
#define ADMXRC6TADV8_AVR_FLASH_VPD_OFFSET (0x3F00U) /* Offset (bytes) into of Flash memory in AVR uC where VPD is located */

#endif
