/*
** File: admxrc2l.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-II-Lite
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADMXRC2L_H)
#define _ADATA_CORE_ADMXRC2L_H

#include "pci9xxx.h"

/* Model-specific registers in PCI9xxx BAR3 for ADM-XRC & ADM-XRC-P */
#pragma pack(1)
typedef struct _ModelRegsAdmxrc2l {
  uint8_t fcon;            /* 0x00 */
  uint8_t ccon;            /* 0x01 */
  uint8_t imset;           /* 0x02 */
  uint8_t imclr;           /* 0x03 */
  uint8_t icon;            /* 0x04 */
  uint8_t _reserved1[3];   /* 0x05 */
  uint8_t smap[4];         /* 0x08 */
  uint8_t _reserved2[4];   /* 0x0C */
} ModelRegsAdmxrc2l;       /* 0x10 */
#pragma pack()

/* Fields for ModelRegsAdmxrc::fcon */
#define ADMXRC2L_FCON_PROG ((uint8_t)(1U << 0))
#define ADMXRC2L_FCON_INIT ((uint8_t)(1U << 1))
#define ADMXRC2L_FCON_DONE ((uint8_t)(1U << 2))

/* Fields for ModelRegsAdmxrc2::icon register */
#define ADMXRC2L_ICON_FPGA (0x1U << 0)

/* Byte address of VPD structure below in PCI9080's EEPROM */
#define ADMXRC2L_EEPROM_VPD_OFFSET (0x6CU)

#pragma pack(1)
/* Always LITTLE ENDIAN when stored in hardware */
typedef struct _VpdAdmxrc2lRev0 {
  uint16_t _reserved1;    /* 0x00 (0x6C)  (Reserved) */
  uint16_t modifications; /* 0x02 (0x6E)  Bitmap; nothing defined yet */
  uint16_t refClock;      /* 0x04 (0x70)  Reference oscillator type; 0 => 16.66667 MHz, 1 => 14.31818MHz */
  uint16_t flashType;     /* 0x06 (0x72)  Flash type; 2 => Common Flash Interface (CFI) device */
  uint16_t  zbt0123;      /* 0x08 (0x74)  See comments below */
  uint16_t cardId;        /* 0x0A (0x76)  Card ID */
  uint16_t fpgaType;      /* 0x0C (0x78)  Device fitted; see ADMXRC2_FPGA_TYPE */
  uint16_t serialLow;     /* 0x0E (0x7A)  Serial number bits [15:0] */
  uint16_t serialHigh;    /* 0x10 (0x7C)  Serial number bits [31:16] */
  uint8_t  cpldRev;       /* 0x12 (0x7E)  CPLD revision */
  uint8_t  pcbRev;        /* 0x13 (0x7F)  Board revision */
} VpdAdmxrc2lRev0;        /* 0x14 (0x80) */
/*
** Bitfields of member 'zbt0123':
**     [0] 1 => bank 0 supports ZBT flow-through mode
**     [1] 1 => bank 0 supports ZBT pipelined mode
**   [3:2] bank 0 size: 0 => 512 kWord, 1 => 1 MWord, 2 => 2 MWord, 3 => (reserved)
**     [4] 1 => bank 1 supports ZBT flow-through mode
**     [5] 1 => bank 1 supports ZBT pipelined mode
**   [7:6] bank 1 size: 0 => 512 kWord, 1 => 1 MWord, 2 => 2 MWord, 3 => (reserved)
**     [8] 1 => bank 2 supports ZBT flow-through mode
**     [9] 1 => bank 2 supports ZBT pipelined mode
** [11:10] bank 2 size: 0 => 512 kWord, 1 => 1 MWord, 2 => 2 MWord, 3 => (reserved)
**    [12] 1 => bank 3 supports ZBT flow-through mode
**    [13] 1 => bank 3 supports ZBT pipelined mode
** [15:14] bank 3 size: 0 => 512 kWord, 1 => 1 MWord, 2 => 2 MWord, 3 => (reserved)
*/
#pragma pack()

#endif
