/*
** File: admxrc2.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC-II
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADMXRC2_H)
#define _ADATA_CORE_ADMXRC2_H

#include "pci9xxx.h"

/* Model-specific registers in PCI9xxx BAR3 */
#pragma pack(1)
typedef struct _ModelRegsAdmxrc2 {
  uint8_t fcon;           /* 0x00 */
  uint8_t ccon;           /* 0x01 */
  uint8_t imset;          /* 0x02 */
  uint8_t imclr;          /* 0x03 */
  uint8_t icon;           /* 0x04 */
  uint8_t pstat;          /* 0x05 */
  uint8_t mode;           /* 0x06 */
  uint8_t flpage;         /* 0x07 */
  uint8_t smap[4];        /* 0x08 */
  uint8_t _reserved1[4];  /* 0x0C */
} ModelRegsAdmxrc2;       /* 0x10 */
#pragma pack()

/* Fields for ModelRegsAdmxrc2::fcon */
#define ADMXRC2_FCON_PROG ((uint8_t)(1U << 0))
#define ADMXRC2_FCON_INIT ((uint8_t)(1U << 1))
#define ADMXRC2_FCON_DONE ((uint8_t)(1U << 2))

/* Fields for ModelRegsAdmxrc2::icon register */
#define ADMXRC2_ICON_FPGA (0x1U << 0)

/* Vital Product data; always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxrc2Rev0 {
  uint16_t model;         /* 0x00 (0x6A) 3 => ADM-XRC-II */
  uint16_t modifications; /* 0x02 (0x6C) Bitmap; nothing defined yet */
  uint16_t refClock;      /* 0x04 (0x6E) 1 => 14.31818MHz */
  uint16_t flashType;     /* 0x06 (0x70) 2 => Common Flash Interface (CFI) device */
  uint8_t  zbt01;         /* 0x08 (0x72) ZBT size & type information for banks 0 to 1 */
  uint8_t  zbt23;         /* 0x09 (0x73) ZBT size & type information for banks 2 to 3 */
  uint8_t  zbt45;         /* 0x0A (0x74) ZBT size & type information for banks 4 to 5 */
  uint8_t  _reserved1;    /* 0x0B (0x75) */
  uint16_t cardId;        /* 0x0C (0x76) Card ID */
  uint16_t fpgaType;      /* 0x0E (0x78) Device fitted; see ADMXRC2_FPGA_TYPE */
  uint32_t serialNumber;  /* 0x10 (0x7A) Serial number */
  uint8_t  cpldRev;       /* 0x14 (0x7C) CPLD revision */
  uint8_t  pcbRev;        /* 0x15 (0x7E) Board revision */
} VpdAdmxrc2Rev0;         /* 0x16 (0x80) */
#pragma pack()

/* Byte address of VpdAdmxrc2Rev0 structure in PCI9656's configuration EEPROM */
#define ADMXRC2_EEPROM_VPD_OFFSET (0x6AU)

#endif
