/*
** File: admxrc.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XRC & ADM-XRC-P
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADMXRC_H)
#define _ADATA_CORE_ADMXRC_H

#include "pci9xxx.h"

/* Model-specific registers in PCI9xxx BAR3 for ADM-XRC & ADM-XRC-P */
#pragma pack(1)
typedef struct _ModelRegsAdmxrc {
  uint8_t fcon;          /* 0x00 */
  uint8_t ccon;          /* 0x01 */
  uint8_t imset;         /* 0x02 */
  uint8_t imclr;         /* 0x03 */
  uint8_t icon;          /* 0x04 */
  uint8_t _reserved1[3]; /* 0x05 */
  uint8_t smap[4];       /* 0x08 */
  uint8_t _reserved2[4]; /* 0x0C */
} ModelRegsAdmxrc;       /* 0x10 */
#pragma pack()

/* Fields for ModelRegsAdmxrc::fcon */
#define ADMXRC_FCON_PROG ((uint8_t)(1U << 0))
#define ADMXRC_FCON_INIT ((uint8_t)(1U << 1))
#define ADMXRC_FCON_DONE ((uint8_t)(1U << 2))

/* Fields for ModelRegsAdmxrc2::icon register */
#define ADMXRC_ICON_FPGA (0x1U << 0)

/* Byte address of VPD structure below in PCI9080's EEPROM */
#define ADMXRC_EEPROM_VPD_OFFSET (0x6CU)

#pragma pack(1)
/* Always LITTLE ENDIAN when stored in hardware */
typedef struct _VpdAdmxrcRev0 {
  uint16_t model;         /* 0x00 (0x6C) Model type; 0 => ADM-XRC, 1 => ADM-XRC-P */
  uint16_t modifications; /* 0x02 (0x6E) Bitmap; nothing defined yet */
  uint16_t refClock;      /* 0x04 (0x70) Reference oscillator type; 0 => 16.66667 MHz, 1 => 14.31818MHz */
  uint16_t flashType;     /* 0x06 (0x72) Flash type; 2 => Common Flash Interface (CFI) device */
  uint8_t  zbt0123;       /* 0x08 (0x74) See comments below */
  uint8_t  _reserved1;    /* 0x09 (0x75) (reserved) */
  uint16_t cardId;        /* 0x0A (0x76) Card ID */
  uint16_t fpgaType;      /* 0x0C (0x78) Device fitted; see ADMXRC2_FPGA_TYPE */
  uint16_t serialLow;     /* 0x0E (0x7A) Serial number bits [15:0] */
  uint16_t serialHigh;    /* 0x10 (0x7C) Serial number bits [31:16] */
  uint8_t  cpldRev;       /* 0x12 (0x7E) CPLD revision */
  uint8_t  pcbRev;        /* 0x13 (0x7F) Board revision */
} VpdAdmxrcRev0;          /* 0x14 (0x80) */
/*
** Bitfields of member 'zbt0123':
** [0] 1 => bank 0 is present, 0 => bank 0 is not present
** [1] 1 => bank 1 is present, 0 => bank 1 is not present
** [2] 1 => bank 2 is present, 0 => bank 2 is not present
** [3] 1 => bank 3 is present, 0 => bank 3 is not present
** [4] 1 => bank 0 is 512 kiWord, 0 => bank 0 is 256 kiWord
** [5] 1 => bank 1 is 512 kiWord, 0 => bank 1 is 256 kiWord
** [6] 1 => bank 2 is 512 kiWord, 0 => bank 2 is 256 kiWord
** [7] 1 => bank 3 is 512 kiWord, 0 => bank 3 is 256 kiWord
*/
#pragma pack()

/* Flags for VpdAdmxrcRev0:: modifications field */
/* MCLK and VCLK1 pins on ICD2061 are swapped. */
#define ADMXRC_MOD_CLOCKSWAP (1 << 0)

#endif
