/*
** File: admxpl.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XPL.
**
** (C) Copyright Alpha Data 2013
*/

#if !defined(_ADATA_CORE_ADMXPL_H)
#define _ADATA_CORE_ADMXPL_H

#include "adb1.h"

#define ADMXPL_NUM_DMA_CHANNEL (2U)

#pragma pack(1)
typedef struct _ModelRegsAdmxpl {
  uint32_t clock;             /* 0x0000 */
  uint32_t flctl;             /* 0x0004 */
  uint32_t fldata;            /* 0x0008 */
  uint32_t fpctl;             /* 0x000C */
  uint8_t fpsmap[4];          /* 0x0010 */
  uint32_t ictl;              /* 0x0014 */
  uint32_t istat;             /* 0x0018 */
  uint32_t _reserved1[1017];  /* 0x001C */
} ModelRegsAdmxpl;            /* 0x1000 */
#pragma pack()

/* Fields for ModelRegsAdmxpl::fpctl */
#define ADMXPL_FPCTL_PROG   (0x1U << 0)
#define ADMXPL_FPCTL_INIT   (0x1U << 1)
#define ADMXPL_FPCTL_DONE   (0x1U << 2)
#define ADMXPL_FPCTL_RELOAD (0x1U << 31)

/* Fields for ModelRegsAdmxpl::ictl */
#define ADMXPL_ICTL_ENFPGA   (0x1U << 0) /* Enable target FPGA interrupt */

/* Fields for ModelRegsAdmxpl::istat */
#define ADMXPL_ISTAT_IRQFPGA (0x1U << 0) /* Target FPGA interrupt */

/* Address and size of VPD region in Flash */
#define ADMXPL_VPD_OFFSET_IN_FLASH (0U)
#define ADMXPL_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADMXPL_FLASH_TARGET_AREA_START (0x800000U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxplRev0 {
  uint16_t version;        /* 0x00 */
  uint16_t boardType;      /* 0x02 */
  uint32_t modifications;  /* 0x04 */
  uint32_t refClockFreq;   /* 0x08 */
  struct {
    uint8_t order;         /* 0x0C */
    uint8_t width;         /* 0x0D */
    uint16_t typeMask;     /* 0x0E */
  } ssram;
  struct {
    uint8_t order;         /* 0x10 */
    uint8_t width;         /* 0x11 */
    uint16_t typeMask;     /* 0x12 */
  } sdram;
  uint32_t cardId;         /* 0x14 */
  uint32_t serialNumber;   /* 0x18 */
  uint16_t fpgaType;       /* 0x1C */
  uint8_t pcbRev;          /* 0x1E */
  uint8_t logicRev;        /* 0x1F */
} VpdAdmxplRev0;           /* 0x20 */
#pragma pack()

#endif
