/*
** File: admxp.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-XP & ADP-XPI.
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADMXP_H)
#define _ADATA_CORE_ADMXP_H

#include "adb1.h"
#include "admxpl.h"

#define ADMXP_NUM_DMA_CHANNEL (2U)

/* Model-specific register offsets for ADM-XP are the same as ADM-XPL, but register fields are not all the same. */
typedef ModelRegsAdmxpl ModelRegsAdmxp;

/* Fields for ModelRegsAdmxp::fpctl */
#define ADMXP_FPCTL_PROG   (0x1U << 0)
#define ADMXP_FPCTL_INIT   (0x1U << 1)
#define ADMXP_FPCTL_DONE   (0x1U << 2)
#define ADMXP_FPCTL_RELOAD (0x1U << 31)

/* Fields for ModelRegsAdmxp::ictl */
#define ADMXP_ICTL_ENFPGA   (0x1U << 0) /* Enable target FPGA interrupt */

/* Fields for ModelRegsAdmxp::istat */
#define ADMXP_ISTAT_IRQFPGA (0x1U << 0) /* Target FPGA interrupt */

/* Address and size of VPD region in Flash */
#define ADMXP_VPD_OFFSET_IN_FLASH (0U)
#define ADMXP_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADMXP_FLASH_TARGET_AREA_START (0x800000U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmxpRev0 {
  uint16_t version;         /* 0x00 */
  uint16_t boardType;       /* 0x02 */
  uint32_t modifications;   /* 0x04 */
  uint32_t refClockFreq;    /* 0x08 */
  struct {
    uint8_t order;          /* 0x0C, 0x0E, 0x10, 0x12 */
    uint8_t _reserved1;     /* 0x0D, 0x0F, 0x11, 0x13 */
  } ssram[4];
  struct {
    uint8_t order;          /* 0x14, 0x16 */
    uint8_t _reserved1;     /* 0x15, 0x17 */
  } sdram[2];
  uint32_t cardId;          /* 0x18 */
  uint32_t serialNumber;    /* 0x1C */
  uint16_t fpgaType;        /* 0x20 */
  uint8_t pcbRev;           /* 0x22 */
  uint8_t logicRev;         /* 0x23 */
} VpdAdmxpRev0;             /* 0x24 */
#pragma pack()

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdpxpiRev0 {
  uint16_t version;         /* 0x00 */
  uint16_t boardType;       /* 0x02 */
  uint32_t modifications;   /* 0x04 */
  uint32_t refClockFreq;    /* 0x08 */
  struct {
    uint8_t order;          /* 0x0C, 0x0E, 0x10, 0x12 */
    uint8_t _reserved1;     /* 0x0D, 0x0F, 0x11, 0x13 */
  } sdram[4];
  struct {
    uint8_t order;          /* 0x14 */
    uint8_t _reserved1;     /* 0x15 */
  } ssram[1];
  uint16_t _reserved1;      /* 0x16 */
  uint32_t cardId;          /* 0x18 */
  uint32_t serialNumber;    /* 0x1C */
  uint16_t fpgaType;        /* 0x20 */
  uint8_t pcbRev;           /* 0x22 */
  uint8_t logicRev;         /* 0x23 */
} VpdAdpxpiRev0;            /* 0x24 */
#pragma pack()

#endif
