/*
** File: admpcieku3.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADM-PCIE-KU3.
**
** (C) Copyright Alpha Data 2015
*/

#ifndef _ADATA_CORE_ADMPCIEKU3_H
#define _ADATA_CORE_ADMPCIEKU3_H

#include <df.h>
#include "adb3.h"
#include "admxrc6tx.h"
#include "ddr3_spd.h"

#define ADMPCIEKU3_NUM_DMA_CHANNEL (4)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdmpcieku3Rev0 {
	uint16_t version;          /* 0x00 Revision of this structure (0) */
	uint16_t length;           /* 0x02 Length of this structure including checksum */
	uint32_t partNumber;       /* 0x04 Part number: 1284 => ADM-PCIE-7V3 */
	uint32_t serial;           /* 0x08 Board serial number */
	uint8_t  pcbRev;           /* 0x0C PCB revision 0xAB where A is major, B is minor */
  uint8_t _reserved1[3];     /* 0x0D */
	uint32_t si5338Ref;        /* 0x10 Frequency of SI5338 reference oscillator, in Hz */
	uint32_t dimmRef[2];       /* 0x14 Reference clock frequency for DIMMs 0 & 1 */
  uint32_t sfpMgtRef;        /* 0x1C Reference clock frequency for SFP MGTs */
  uint32_t sataMgtRef;       /* 0x20 Reference clock frequency for SATA MGTs */
  uint32_t cclkRef;          /* 0x24 Reference clock frequency for CCLK */
  uint8_t _reserved2[8];     /* 0x28 */
  uint8_t _reserved3[16];    /* 0x30 Placeholder for DIMM VPD if needed */
  struct {
    uint8_t  stepping[8];    /* 0x40 Stepping level of target FPGA */
    uint8_t  speedGrade[4];  /* 0x48 Speed grade of target FPGA */
    uint16_t device;         /* 0x4C Device code of target FPGA */
    uint8_t  tempGrade;      /* 0x4E Temperature grade of target FPGA; see definitions below */
    uint8_t  _reserved4;     /* 0x4F */
  } fpga;
  uint8_t  checksum;         /* 0x50 This MUST ALWAYS be the last member in the struct */
} VpdAdmpcieku3Rev0;
#pragma pack()

typedef struct _VpdAdmpcieku3 {
  union {
    VpdAdmpcieku3Rev0 rev0;
  } prom;
	struct {
    uint64_t physicalSize; /* In 64-bit words */
		uint32_t freqMax;      /* Maximum DIMM operating frequency, in Hz */
    boolean_t bHasEcc;     /* TRUE => has 8 bits of ECC */
	} dimm[2];
} VpdAdmpcieku3;

/* Values for VpdAdmpcieku3Rev0::modifications */
/* TO DO */

/* Values for VpdAdmpcieku3Rev0::fpga::tempGrade */
#define ADMPCIEKU3_VPD_TEMPGRADE_COMMERCIAL  ADMXRC6Tx_VPD_TEMPGRADE_COMMERCIAL
#define ADMPCIEKU3_VPD_TEMPGRADE_INDUSTRIAL  ADMXRC6Tx_VPD_TEMPGRADE_INDUSTRIAL
#define ADMPCIEKU3_VPD_TEMPGRADE_EXTENDED    ADMXRC6Tx_VPD_TEMPGRADE_EXTENDED

/* Fields for ModelRegsAdmxrc6tx::intCtl */
#define ADMPCIEKU3_V_INTCTL_LEVELBITS (ADMXRC6Tx_V_INTCTL_SYSLEVEL /* | TO DO */)

/* Fields for ModelRegsAdmxrc6tx::intStat */
#define ADMPCIEKU3_V_INTSTAT_LEVELBITS (ADMXRC6Tx_V_INTSTAT_SYS /* | TO DO */)

/* M24C02 (2 kbit => 256 B) PROMs are fitted to boards. */
#define ADMPCIEKU3_VPD_ROM_SIZE     (0x100U)
#define ADMPCIEKU3_VPD_ROM_I2C_BUS  (1U)
#define ADMPCIEKU3_VPD_ROM_I2C_SLOT (0x50U)

/* SODIMM slot SPD definitions */
#define ADMPCIEKU3_DIMM_SPD_ROM_SIZE       (0x100U)
#define ADMPCIEKU3_DIMM_SPD_I2C_BUS        (2U)
#define ADMPCIEKU3_DIMM_SPD_I2C_SLOT(bank) DDR3_I2C_SLOT_SPD_ROM(bank)

/* SI5338s are on I2C bus 1 on ADM-PCIE-7V3 rev. 2 */
#define ADMPCIEKU3_SI5338_I2C_BUS    (1U)
#define ADMPCIEKU3_SI5338_1_I2C_SLOT (0x70U)
#define ADMPCIEKU3_SI5338_2_I2C_SLOT (0x71U)

/* Delay counter in IPROG reconfiguration logic operates from LCLK, 40 MHz */
#define ADMPCIEKU3_IPROG_DELAYCNT_FREQ_HZ (40000000U)

#endif
