/*
** File: adcpxrc4lx.h  
** Project: ADB3 core driver
** Purpose: Definitions specific to ADCP-XRC-4LX
**
** (C) Copyright Alpha Data 2014
*/

#if !defined(_ADATA_CORE_ADCPXRC4LX_H)
#define _ADATA_CORE_ADCPXRC4LX_H

#include "adb1.h"

#define ADCPXRC4LX_NUM_DMA_CHANNEL (4U)

/* Address and size of VPD region in Flash */
#define ADCPXRC4LX_VPD_OFFSET_IN_FLASH (0U)
#define ADCPXRC4LX_VPD_SIZE_IN_FLASH   (0x20000U)

/* Beginning of useable area in Flash for storing target bitstreams */
#define ADCPXRC4LX_FLASH_TARGET_AREA_START (0x800000U)

/* Number of sensors */
#define ADCPXRC4LX_NUM_LM87_SENSOR (9U)

/* Always LITTLE ENDIAN when stored in hardware */
#pragma pack(1)
typedef struct _VpdAdcpxrc4lxRev0 {
  uint16_t version;         /* 0x00 */
  uint16_t _reserved1;      /* 0x02 */
  uint32_t modifications;   /* 0x04 */
  uint8_t stepping;         /* 0x08 */
  uint8_t _reserved2[3];    /* 0x09 */
  uint32_t scd;             /* 0x0c */
  uint32_t _reserved3[4];   /* 0x10 */
  struct {
    uint8_t order;          /* 0x20, 0x22 */
    uint8_t _reserved1;     /* 0x21, 0x23 */ 
  } sdram[2];
  struct {
    uint8_t order;          /* 0x24, 0x26 */
    uint8_t _reserved1;     /* 0x25, 0x27 */
  } zbt[2];
  uint32_t cardId;          /* 0x28 */
  uint32_t serialNumber;    /* 0x2C */
  uint16_t fpgaType;        /* 0x30 */
  uint8_t pcbRev;           /* 0x32 */
  uint8_t cpldRev;          /* 0x33 */
} VpdAdcpxrc4lxRev0;        /* 0x34 */
#pragma pack()

#endif
