/*
** File: adb3_common.h  
** Project: ADB3 core driver
** Purpose: Prototype of common ADB3 methods
**
** (C) Copyright Alpha Data 2010
*/

#ifndef _ADATA_CORE_ADB3_COMMON_H
#define _ADATA_CORE_ADB3_COMMON_H

#include "coreif.h"
#include "device.h"

extern void
adb3DmaList(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bWriteToDevice,
  boolean_t bFixedLocal,
  DfDmaMapperNode* pTable,
  unsigned int tableLength,
  DmaNodeTablePosition* pTablePosition,
  void* pDescriptorBuffer,
  unsigned int maxDescriptor,
  uint64_t descriptorBusAddress);

extern void
adb3DmaTransfer(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel,
  boolean_t bStart,
  void* pDescriptorBuffer,        /* Valid iff 'bStart' is TRUE */
  uint64_t descriptorBusAddress); /* Valid iff 'bStart' is TRUE */

/* Figure out number of DMA engines present and which directions they support */
extern unsigned int
adb3CountDmaEngines(
  Adb3CoreDeviceContext* pDevCtx);

/* MSI problem workaround - disable all interrupts then reenable */
DF_DECLARE_INLINE_FUNC(void, adb3MsiWorkaround)(
	Adb3CoreDeviceContext* pDevCtx)
{
  Adb3GenericRegs* pRegs;
  DfMemoryHandle hBridge;

  pRegs = pDevCtx->hardware.bridge.pAdb3;
  hBridge = pDevCtx->hardware.hBridge;

  dfPciMemWrite32(hBridge, &pRegs->irqEnable, 0);
  dfPciMemRead32(hBridge, &pRegs->irqEnable);
  dfPciMemWrite32(hBridge, &pRegs->irqEnable, pDevCtx->hardware.shadow.bridge.adb3.irqEnable);
  dfPciMemRead32(hBridge, &pRegs->irqEnable);
}

extern void
adb3InitDmaEngines(
  Adb3CoreDeviceContext* pDevCtx,
  unsigned int count);

extern boolean_t
adb3NeedMsiWorkaround(
	Adb3CoreDeviceContext* pDevCtx);

extern boolean_t
adb3HasIcapInterface(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3ClearErrors(
	Adb3CoreDeviceContext* pDevCtx);

extern void
adb3GetDeviceStatus(
	Adb3CoreDeviceContext* pDevCtx,
  CoreDeviceStatus* pDeviceStatus);

extern void
adb3DumpDmaDescriptors(
	Adb3CoreDeviceContext* pDevCtx,
  Adb3DmaDescriptor* pDescriptors,
  uint64_t descBus,
  unsigned int count);

extern void
adb3DumpDmaRegisters(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int channel);

extern boolean_t
adb3VerifyChecksum(
	Adb3CoreDeviceContext* pDevCtx,
  uint16_t vpdLength);

extern void
adb3EnableInterrupts(
  Adb3CoreDeviceContext* pDevCtx,
  boolean_t bEnable);

extern CoreWindowConfigStatus
adb3GetWindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  CoreWindowConfig* pConfig);

extern CoreWindowConfigStatus
adb3SetWindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  uint32_t flags,
  const CoreWindowConfig* pConfig);

extern CoreWindowConfigStatus
adb3WindowConfig(
	Adb3CoreDeviceContext* pDevCtx,
  unsigned int windowIndex,
  boolean_t bConfigure,
  uint32_t flags,
  CoreWindowConfig* pConfig);

extern boolean_t
adb3ForcePcieGen(
  Adb3CoreDeviceContext* pDevCtx,
  uint32_t speed);

#endif
