#if !defined(_ADATA_PLATFORM_IOCTL_DFLINUX_H)
#define _ADATA_PLATFORM_IOCTL_DFLINUX_H

/*
** File: ioctl_dflinux.h  
** Project: Linux Driver Framework
** Purpose: Definitions for special IOCTLs used by Linux Driver Framework.
**
** (C) Copyright Alpha Data 2010
**
** IOCTL numbers 0x00 - 0x3F are for use by platform-independent blocking IOCTLs
** IOCTL numbers 0x40 - 0x7F are for use by platform-independent non-blocking IOCTLs
** IOCTL numbers 0x80 - 0xFF are reserved for Linux driver framework IOCTLs
*/

#if _IOC_NRBITS < 8
# error Expect _IOC_NRBITS to be at least 8.
#endif

#define DFLINUX_IOCTL_BASE               (0x80U)

#define DFLINUX_IOCTLCODE_GETMMAPADDRESS (0x1U + DFLINUX_IOCTL_BASE)
#define DFLINUX_IOCTLCODE_CANCEL         (0x2U + DFLINUX_IOCTL_BASE)
#define DFLINUX_IOCTLCODE_FINISH         (0x3U + DFLINUX_IOCTL_BASE)
#define DFLINUX_IOCTLCODE_FINISHWAIT     (0x4U + DFLINUX_IOCTL_BASE)

typedef enum _DfLinuxMmapStatus {
  DfLinuxMmapSuccess = 0,
  DfLinuxMmapInvalidRegion,
  DfLinuxMmapInvalidTag,
  DfLinuxMmapNoMemory,
  DfLinuxMmapRegionTooLarge,
  DfLinuxMmapAccessDenied,
  DfLinuxMmapGeneralFailure
} DfLinuxMmapStatus;

typedef union _DfLinuxIoctlGetMmapAddress {
  struct {
    uint32_t regionTag;
  } in;
  struct {
    /* Returned region described by following two members is not necessarily page-aligned. */
    /* Must be page-aligned before using with mmap(). */
    uint64_t address;
    uint64_t length;
  } out;
} DfLinuxIoctlGetMmapAddress;

typedef enum _DfLinuxCancelStatus {
  DfLinuxCancelSuccess = 0
} DfLinuxCancelStatus;

#endif
