-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_tap_logic_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module instantiates the tap_cntrl and the data_tap_inc 
-- 			   modules. Used for calibration of the memory data with 
--			   the FPGA clock.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on


entity mem_interface_small_tap_logic_0 is 
port (
      CLK                  : in std_logic;
      CAL_CLK              : in std_logic;
      RESET0               : in std_logic;
      RESET_CAL_CLK        : in std_logic;
      CTRL_DUMMYREAD_START : in std_logic;
      idelay_ctrl_rdy      : in std_logic;
      dqs_delayed          : in std_logic_vector(data_strobe_width-1 downto 0);
      
      data_idelay_inc      : out std_logic_vector(ReadEnable-1 downto 0); 
      data_idelay_ce       	: out std_logic_vector(ReadEnable-1 downto 0); 
      data_idelay_rst       : out std_logic_vector(ReadEnable-1 downto 0); 
      dqs_idelay_inc      : out std_logic_vector(ReadEnable-1 downto 0); 
      dqs_idelay_ce       : out std_logic_vector(ReadEnable-1 downto 0); 
      dqs_idelay_rst      : out std_logic_vector(ReadEnable-1 downto 0); 
      
      SEL_DONE             : out std_logic
      );
end entity;

architecture arc_tap_logic of mem_interface_small_tap_logic_0 is


component mem_interface_small_tap_ctrl
port (
      CAL_CLK              : in std_logic;
      RESET                : in std_logic;
      RDY_STATUS           : in std_logic;
      DQS                  : in std_logic;
      CTRL_DUMMYREAD_START : in std_logic;
      DLYINC               : out std_logic;
      DLYCE                : out std_logic;
      DLYRST               : out std_logic;
      SEL_DONE             : out std_logic;
      VALID_DATA_TAP_COUNT : out std_logic;
      DATA_TAP_COUNT       : out std_logic_vector(5 downto 0)
      );
end component;

component mem_interface_small_data_tap_inc
port (
      CAL_CLK              : in std_logic;
      RESET                : in std_logic;
      DQS_SEL_DONE         : in std_logic;
      DATA_DLYINC          : out std_logic; 
      DATA_DLYCE           : out std_logic;  
      DATA_DLYRST          : out std_logic;
      DATA_TAP_SEL_DONE    : out std_logic;
      VALID_DATA_TAP_COUNT : in std_logic;
      DATA_TAP_COUNT       : in std_logic_vector(5 downto 0)
     );
end component;


signal data_tap_select   : std_logic_vector(ReadEnable-1 downto 0);
signal dqs_tap_sel_done  : std_logic_vector(ReadEnable-1 downto 0);
signal valid_tap_count   : std_logic_vector(ReadEnable-1 downto 0);
     
signal data_tap_count0 : std_logic_vector(5 downto 0);

signal data_tap_inc_done   : std_logic;
signal tap_sel_done        : std_logic;

begin

-- For controller to stop dummy reads

 SEL_DONE <= tap_sel_done;


   process(CLK)
   begin
     if CLK'event and CLK = '1' then 
       if (RESET0 = '1') then
--         data_tap_inc_done            <= '0';
--         tap_sel_done                  <= '0';
       else
         data_tap_inc_done   <=  data_tap_select(0)   ;
         
         tap_sel_done           <= data_tap_inc_done;
       end if;
     end if;
   end process;
 


--/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
--//  tap_ctrl instances for  DDR_DQS strobes
--/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    tap_ctrl_0 : mem_interface_small_tap_ctrl
    port map    (
                    CAL_CLK              =>  CAL_CLK,
                    RESET                =>  RESET_CAL_CLK,
                    RDY_STATUS           =>  idelay_ctrl_rdy,
                    DQS                  =>  dqs_delayed(3),
                    CTRL_DUMMYREAD_START =>  CTRL_DUMMYREAD_START,
                    DLYINC               =>  dqs_idelay_inc(0),
                    DLYCE                =>  dqs_idelay_ce(0),
                    DLYRST               =>  dqs_idelay_rst(0),
                    SEL_DONE             =>  dqs_tap_sel_done(0),
                    VALID_DATA_TAP_COUNT =>  valid_tap_count(0),
                    DATA_TAP_COUNT       =>  data_tap_count0(5 downto 0)
                 );


                         
--/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
--//  instances of data_tap_inc for each dqs and associated tap_ctrl
--/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   data_tap_inc_0 : mem_interface_small_data_tap_inc
    port map   (
                    CAL_CLK              => CAL_CLK,
                    RESET                => RESET_CAL_CLK,
                    DQS_SEL_DONE         => dqs_tap_sel_done(0),
                    DATA_DLYINC          => data_idelay_inc(0),
                    DATA_DLYCE           => data_idelay_ce(0),
                    DATA_DLYRST          => data_idelay_rst(0),
                    DATA_TAP_SEL_DONE    => data_tap_select(0),
                    VALID_DATA_TAP_COUNT => valid_tap_count(0),
                    DATA_TAP_COUNT       => data_tap_count0(5 downto 0)
                 );






end arc_tap_logic;
