#!/usr/bin/env python2
# Tile:		testPreSeriesTest3
# Author:	M.Thomas BEAM Ltd
# Date:		2007-05-09
#
# Contents:	Performs the testing specfied in the pre-series test schedule - Test 3
#

import sys
from TestHarness import *

def getPlots():
	s = ""
	plots = "sigma deltaX deltaY\n";
	for i in plots.split():
		s += "-y " + i + " "
	return s;

def main():
	t = TestHarness()

	info = DataCaptureInfo();
	
	print "Test 3.5
	print "Capture the Sigma/DeltaX/DeltaY data from a single PickUp for each bunch"
	print "bunches over the harmonic 16 cycle period"
	print
	
	t.runTest("tmsControl --init " + t.host,"Failure during init")
	t.runTest("tmsControl --cycleType beam3 " + t.host,"Failure cycle type setup")
	
	info.data['channel'] 		="1"
	info.data['period'] 		="3"		# Cycle Harmonic 1
	info.data['startTime'] 		="0"
	info.data['orbit'] 		="0"
	info.data['bunch'] 		="4"		# Bunches spec
	info.data['numSamples'] 	="1024"
	info.data['function'] 		="0"
	print info.printIt();

	t.runTest("tmsControl --kst --readData " + info.getString() + " -outFile data.txt " + t.host,"Error reading data")
	t.runTest("kst -m 1 -x INDEX " + getPlots() + "data.txt","Kst invoke failed")

if __name__ =="__main__":
	main();
