#!/usr/bin/env python2
# Tile:		testPreSeriesTest3
# Author:	M.Thomas BEAM Ltd
# Date:		2007-05-09
#
# Contents:	Performs the testing specfied in the pre-series test schedule - Test 3
#

import sys
from TestHarness import *

def main():
	t = TestHarness()

	info = DataCaptureInfo();
	
	t.runTest("tmsControl --init " + t.host,"Failure during init")
	t.runTest("tmsControl --cycleType beam3 " + t.host,"Failure cycle type setup")
	
	info.data['channel'] 		="1"
	info.data['period'] 		="0"
	info.data['startTime'] 		="0"
	info.data['orbit'] 		="0"
	info.data['bunch'] 		="0"
	info.data['numSamples'] 	="1024"
	info.data['function'] 		="0"
	print info.printIt();

	t.runTest("tmsControl  --kst --readData " + info.getString() + " -outFile data.txt " + t.host,"Error reading data")
	t.runTest("kst --config kst.config -m 2 -x INDEX -F data.txt kst/plotSXY.kst","Kst invoke failed")

if __name__ =="__main__":
	main();
