#!/usr/bin/env python2
# Tile:		testPLL
# Author:	M.Thomas BEAM Ltd
# Date:		2007-05-09
#
# Contents:	Test in tms PPL internals
#

import sys
import os
from TestHarness import *

# Columns in data file - Refer tmsControl source for details


def getPlots():
	s = ""
	plots = "fref sigma lo1 lo2 gate blr mean1 mean2 dds_freq rfSelect1 rfSelect2 selFilter top[7] top[6] top[5] top[4] top[3] top[2] top[1] top[0]"
	for i in plots.split():
		s += "-y " + i + " "
	return s;



def main():
	t = TestHarness()

	info = TestCaptureInfo();

	t.runTest("tmsControl --init " + t.host,"Failure during init")
	t.runTest("tmsControl --cycleType beam3 " + t.host,"Failure cycle type setup")
	t.runTest("tmsControl  --setTestData 1," + t.dataFile + " " + t.host,"Failure geting test data")

	info.data['channel'] 		= "1"
	info.data['source'] 		= "0"
	info.data['clock'] 		= "0"
	info.data['startTime'] 		= "0"
	info.data['postTriggerDelay'] 	= "0"
	info.data['triggerAnd'] 	= "0"
	info.data['triggerStore'] 	= "0"
	info.data['triggerSourceData'] 	= "2"
	print info.printIt();
	t.runTest("tmsControl  --kst --captureDiagnostics " + info.getString() + " -outFile data1.txt " + t.host,"Error getting data")
	t.runTest("tmsControl  --kst --captureDiagnostics " + info.getString() + " -outFile data2.txt " + t.host,"Error getting data")

	s = t.merge("data.txt",("data1.txt","data2.txt"),("fref","sigma"))
	t.runTest("kst -m 2 -x INDEX " + s + " data.txt","Kst invoke failed")

if __name__ =="__main__":
	main();
