function [sig] = genSine(sampleRate, numSamples, freq)
	sig = cos(2 * pi * freq / sampleRate * (0:(numSamples-1)));		% Simple sine
endfunction

function [r] = rms(signal)
	r = sqrt(mean(signal .* signal));
endfunction

# In Octave filter design the filter routines are given a cutoff value of 0-1. Where 1 = fs/2.
#
function [ rad ] = cutOff(freq, sampleRate)
	rad = (2 * freq) / sampleRate;
end

function [ freqList ] = getFreqList(startFreq, endFreq, number)
	freqList = startFreq:(endFreq-startFreq)/number:endFreq;
end

sampleRate		= 125000000 / 2;	% Sample Rate Hz
numSamples		= 1024;			% Number of samples length of test vector (1 sec realtime)

frange = 0:sampleRate/(4*512):sampleRate/4;

if(0)
	# Perform first FIR low-pass filter and decimate
	b = fir1(3, cutOff(4370000, sampleRate), hamming(3+1));
#	freqz(b, 1, 512, "whole", sampleRate);
	freqz(b, 1, frange, sampleRate);
	input('Type to continue');
	exit(0);
	
	# Perform second Butterworth low-pass filter
	[b, a] = butter(2, cutOff(4370000, sampleRate));
#	freqz(b, a, 512, "whole", sampleRate);
	freqz(b, 1, frange, sampleRate);
	input('Type to continue');
endif

if(0)
	a = [1 -1.991114292201654, 0.991153595868935];
	b = [1 2 1];

#	freqz(b, a, 512, "whole", sampleRate);
	freqz(b, 1, frange, sampleRate);
	input('Type to continue');
	exit(0);	
endif

if(0)
	a = [1 -1.991114292201654, 0.991153595868935];
	b = [1 2 1];

#	freqz(b, a, 512, "whole", sampleRate);
	freqz(b, 1, frange, sampleRate);
	input('Type to continue');
	exit(0);	
endif

if(0)
	a = [1 1/256-1];
	b = [1 0 1/1024-1];

	freqz(1, a, 512, "whole", sampleRate);
	#freqz(1, a, 1, "whole");
	#freqz(1, a, 512);
	input('Type to continue');
	exit(0);

	n2 = filter(1,a,n1);
	n3 = filter(1,a,n2);
	n4 = filter(b,1,n3);
	n5 = filter(1,a,n4);
	n6 = filter(b,1,n5);
endif



function [res] = filter1(sig)
	sampleRate = 125000000 / 2;	% Sample Rate Hz
	
	[b, a] = butter(2, cutOff(437000, sampleRate));

	res = filter(b, a, sig);
endfunction

function [res] = filter2(sig)
	a = [1 -1.991114292201654, 0.991153595868935];
	b = [1 2 1];

	res = filter(b, a, sig);
	res = res * 9.82592e-6;
endfunction

function [res] = filter3(sig)
	a = [1 1/256-1];
	b = [1 0 1/1024-1];

	n2 = filter(1,a,sig);
	n3 = filter(1,a,n2);
	n4 = filter(b,1,n3);
	n5 = filter(1,a,n4);
	n6 = filter(b,1,n5);

	res = n6 / 256;
endfunction

# Matlab
function [res] = filter4(sig)
	mod32 = 2^32; 
	den7  = 2^7;
	den8  = den7*2;
	den9  = 2^9;
	den10 = den8*4;
	den12 = 2^12;

	n6 = s6 = n5 = n4 = s4 = n3 = n2 = n1 = 0;
		
	%Regulator & Low Pass Filter
	res = zeros(1, length(sig));
	for i = 1:length(sig)
		res(i)  = floor(n6/den7); %simulation of n6>>7
		n6 = n5-s6;
		s6 = n5-floor(n5/den10);            
		n5 = n4+n5-floor(n5/den10);         
		n4 = n3-s4;
		s4 = n3-floor(n3/den10);
		n3 = n2+n3-floor(n3/den8);            
		n2 = n1+n2-floor(n2/den8);           
		n1 = sig(i);
	endfor
endfunction

# FPGA
function [res] = filter5(sig)
	mod32 = 2^32; 
	den7  = 2^7;
	den8  = den7*2;
	den9  = 2^9;
	den10 = den8*4;
	den12 = 2^12;

	n6 = s6 = n5 = n4 = s4 = n3 = n2 = n1 = 0;
		
	%Regulator & Low Pass Filter
	res = zeros(1, length(sig));
	for i = 1:length(sig)
		res(i)  = floor(n6/den7); %simulation of n6>>7
		n6 = n5-s6;
		s6 = n5-floor(n5/den10);            
		n5 = n4+n5-floor(n5/den8);         
		n4 = n3-s4;
		s4 = n3-floor(n3/den10);
		n3 = n2+n3-floor(n3/den8);            
		n2 = n1+n2-floor(n2/den8);           
		n1 = sig(i);
	endfor
endfunction

#	n2 <= n1 + n2 - (n2(23) & n2(23) & n2(23) & n2(23) & n2(23) & n2(23) & n2(23) & n2(23) & n2(23 downto 8));
#		n3 <= n2 + n3 - (n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23 downto 8));
#		s4 <= n3  - (n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23) & n3(23)  & n3(23 downto 10));
#	--	s3 <= n3;   --pipeline delay
#		n4 <= n3 - s4;
#		n5 <= n4 + n5 - (n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) &  n5(23 downto 8));
#		s6 <= n5 - (n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23) & n5(23 downto 10));
#	--	s5 <= n5; --pipeline delay
#		n6 <= n5 - s6;
#        n2 <= n1 + n2 - SXT(n2(23 downto 8), 24);
#        n3 <= n2 + n3 - SXT(n3(23 downto 8), 24);
#        s4 <= n3 - SXT(n3(23 downto 10), 24);
#        n4 <= n3 - s4;
#        n5 <= n4 + n5 - SXT(n5(23 downto 8), 24);
#        s6 <= n5 - SXT(n5(23 downto 10), 24);
#        n6 <= n5 - s6; 
	
freqList = getFreqList(0, 1e6, 256);
rmsList = 1:length(freqList);

for f = 1:length(freqList)
#	printf("%f\n", freqList(f));
	sig = 1000 * genSine(sampleRate, numSamples,  freqList(f));

	res = filter5(sig);

	rmsList(f) = rms(res);
endfor

sig = 20 * log10(rmsList);
maxdB = max(sig);
#sig = sig - maxdB;
sig = sig - (20 * log10(1000));

#plot(freqList, rmsList);
plot(freqList, sig);
input('Type to continue');
exit(1);

freqz(1, a);
input('Type to continue');

multiplot(1,2);
subwindow(1,1);
plot(n1);
subwindow(1,2);
plot(n6);
input('Type to continue');
